/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.api;

import binnie.genetics.api.IAnalystPagePlugin;
import binnie.genetics.api.IProducePlugin;
import binnie.genetics.api.acclimatiser.IAcclimatiserManager;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;

public class GeneticsApi {
    private static Collection<IAnalystPagePlugin> analystPagePlugins = new ArrayList<IAnalystPagePlugin>();
    private static Collection<IProducePlugin> producePlugins = new ArrayList<IProducePlugin>();
    public static IAcclimatiserManager acclimatiserManager;

    public static void registerAnalystPagePlugin(IAnalystPagePlugin<?> analystPageFactory) {
        analystPagePlugins.add(analystPageFactory);
    }

    @Nullable
    public static <T extends IIndividual> IAnalystPagePlugin<T> getAnalystPagePlugin(T individual) {
        for (IAnalystPagePlugin plugin : analystPagePlugins) {
            if (!plugin.handles(individual)) continue;
            return plugin;
        }
        return null;
    }

    public static void registerProducePlugin(IProducePlugin producePlugin) {
        producePlugins.add(producePlugin);
    }

    public static Collection<IProducePlugin> getProducePlugins() {
        return Collections.unmodifiableCollection(producePlugins);
    }
}

