/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.fruitpress.recipes;

import binnie.extratrees.api.recipes.IFruitPressManager;
import binnie.extratrees.api.recipes.IFruitPressRecipe;
import binnie.extratrees.machines.fruitpress.recipes.FruitPressRecipe;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FruitPressRecipeManager
implements IFruitPressManager {
    private static Multimap<Item, IFruitPressRecipe> recipes = ArrayListMultimap.create();

    public static boolean isInput(ItemStack itemstack) {
        return FruitPressRecipeManager.getOutput(itemstack) != null;
    }

    @Nullable
    public static FluidStack getOutput(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return null;
        }
        Item item = itemstack.func_77973_b();
        for (IFruitPressRecipe recipe : recipes.get((Object)item)) {
            if (!itemstack.func_77969_a(recipe.getInput())) continue;
            return recipe.getOutput();
        }
        return null;
    }

    @Override
    public void addRecipe(ItemStack stack, FluidStack fluid) {
        if (FruitPressRecipeManager.getOutput(stack) != null) {
            return;
        }
        Item item = stack.func_77973_b();
        recipes.put((Object)item, (Object)new FruitPressRecipe(stack, fluid));
    }

    @Override
    public boolean addRecipe(IFruitPressRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.put((Object)item, (Object)recipe);
    }

    @Override
    public boolean removeRecipe(IFruitPressRecipe recipe) {
        Item item = recipe.getInput().func_77973_b();
        return recipes.get((Object)item).remove(recipe);
    }

    @Override
    public Collection<IFruitPressRecipe> recipes() {
        return recipes.values();
    }
}

