/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.multifence;

import binnie.extratrees.blocks.decor.FenceDescription;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.wood.WoodManager;
import binnie.extratrees.wood.planks.IPlankType;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;

public class MultiFenceRecipeEmbeddedWrapper
implements IShapedCraftingRecipeWrapper {
    private FenceType fenceType;
    @Nullable
    private IPlankType plankType;
    @Nullable
    private IPlankType plankTypeSecondary;

    public MultiFenceRecipeEmbeddedWrapper(FenceType fenceType) {
        this.fenceType = fenceType;
    }

    public MultiFenceRecipeEmbeddedWrapper(IPlankType plankType, FenceType fenceType) {
        this.plankType = plankType;
        this.fenceType = fenceType;
    }

    public MultiFenceRecipeEmbeddedWrapper(FenceDescription fenceDesc) {
        this.plankType = fenceDesc.getPlankType();
        this.plankTypeSecondary = fenceDesc.getSecondaryPlankType();
        this.fenceType = fenceDesc.getFenceType();
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> fences = new ArrayList<ItemStack>();
        ArrayList<ItemStack> planks = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputFences = new ArrayList<ItemStack>();
        if (this.plankType != null) {
            if (this.plankTypeSecondary == null) {
                for (Map.Entry entry : WoodManager.getAllPlankStacks().entrySet()) {
                    IPlankType plankTypeSecondary = (IPlankType)entry.getKey();
                    if (this.plankType == plankTypeSecondary) continue;
                    planks.add(this.plankType.getStack(false));
                    fences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.size, this.fenceType.solid, false), 1));
                    outputFences.add(WoodManager.getFence(this.plankType, plankTypeSecondary, new FenceType(this.fenceType.size, this.fenceType.solid, true), 2));
                }
            } else {
                planks.add(this.plankType.getStack(false));
                fences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.size, this.fenceType.solid, false), 1));
                outputFences.add(WoodManager.getFence(this.plankType, this.plankTypeSecondary, new FenceType(this.fenceType.size, this.fenceType.solid, true), 2));
            }
        } else {
            for (IPlankType iPlankType : WoodManager.getAllPlankTypes()) {
                for (IPlankType plankType : WoodManager.getAllPlankTypes()) {
                    if (plankType == iPlankType) continue;
                    planks.add(plankType.getStack(false));
                    fences.add(WoodManager.getFence(plankType, iPlankType, new FenceType(this.fenceType.size, this.fenceType.solid, false), 1));
                    outputFences.add(WoodManager.getFence(plankType, iPlankType, new FenceType(this.fenceType.size, this.fenceType.solid, true), 2));
                }
            }
        }
        ArrayList<ArrayList<ItemStack>> itemInputs = new ArrayList<ArrayList<ItemStack>>();
        itemInputs.add(fences);
        itemInputs.add(planks);
        itemInputs.add(fences);
        ArrayList<ArrayList<ItemStack>> arrayList = new ArrayList<ArrayList<ItemStack>>();
        arrayList.add(outputFences);
        ingredients.setOutputLists(ItemStack.class, arrayList);
        ingredients.setInputLists(ItemStack.class, itemInputs);
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 1;
    }
}

