/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.jei.distillery;

import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.resource.textures.StandardTexture;
import binnie.core.gui.resource.textures.Texture;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.integration.jei.ExtraTreesJeiPlugin;
import binnie.extratrees.integration.jei.distillery.DistilleryRecipeWrapper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DistilleryRecipeCategory
implements IRecipeCategory<DistilleryRecipeWrapper> {
    private static final Texture DISTILLERY_BASE = new StandardTexture(43, 0, 58, 60, ExtraTreeTexture.GUI);
    private static final Texture LIQUID_FLOW = new StandardTexture(101, 0, 38, 60, ExtraTreeTexture.GUI);
    private final ITickTimer progress = ExtraTreesJeiPlugin.guiHelper.createTickTimer(200, 100, false);

    public String getUid() {
        return "binnie.extratrees.distilling";
    }

    public String getTitle() {
        return "Distilling";
    }

    public String getModName() {
        return ExtraTrees.instance.getModID();
    }

    public IDrawable getBackground() {
        return ExtraTreesJeiPlugin.guiHelper.createBlankDrawable(84, 60);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Minecraft minecraft) {
        CraftGUI.RENDER.texture((ITexture)DISTILLERY_BASE, (IPoint)Point.ZERO);
        CraftGUI.RENDER.texturePercentage(LIQUID_FLOW, new Area(18, 0, 38, 60), Alignment.LEFT, (float)this.progress.getValue() / 100.0f);
    }

    public void setRecipe(IRecipeLayout recipeLayout, DistilleryRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IDrawable tank = ExtraTreesJeiPlugin.drawables.getTank();
        IDrawable tankOverlay = ExtraTreesJeiPlugin.drawables.getTankOverlay();
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        fluidStacks.init(0, true, 1, 1, 16, 58, 1000, false, tankOverlay);
        fluidStacks.setBackground(0, tank);
        fluidStacks.init(1, false, 65, 1, 16, 58, 1000, false, tankOverlay);
        fluidStacks.setBackground(1, tank);
        fluidStacks.set(ingredients);
    }
}

