/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.gui.IWidget;
import binnie.core.genetics.Tolerance;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.renderer.RenderUtil;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.EnumTolerance;
import java.util.EnumSet;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ControlToleranceBar<T extends Enum<T>>
extends Control
implements ITooltip {
    EnumSet<T> tolerated;
    EnumSet<T> fullSet;
    private Class<T> enumClass;

    public ControlToleranceBar(IWidget parent, int x, int y, int width, int height, Class<T> clss) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.MOUSE_OVER);
        this.enumClass = clss;
        this.tolerated = EnumSet.noneOf(this.enumClass);
        this.fullSet = EnumSet.allOf(this.enumClass);
        if (this.enumClass == EnumTemperature.class) {
            this.fullSet.remove(this.enumClass.cast(EnumTemperature.NONE));
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        int types = this.fullSet.size();
        int type = this.getRelativeMousePosition().xPos() / (this.getSize().xPos() / types);
        for (Enum tol : this.fullSet) {
            if (tol.ordinal() - (this.enumClass == EnumTemperature.class ? 1 : 0) != type) continue;
            tooltip.add((this.tolerated.contains(tol) ? "" : TextFormatting.DARK_GRAY) + this.getName(tol));
        }
    }

    protected abstract String getName(T var1);

    protected abstract int getColour(T var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        RenderUtil.drawGradientRect(this.getArea(), -1431655766, -1431655766);
        int w = this.getArea().width() / this.fullSet.size();
        int t = 0;
        for (Enum value : this.fullSet) {
            int col = (this.tolerated.contains(value) ? -16777216 : 0x33000000) + this.getColour(value);
            Border inset = new Border(this.tolerated.contains(value) ? 1 : 3);
            RenderUtil.drawGradientRect(new Area(w * t, 0, w, this.getHeight()).inset(inset), col, col);
            ++t;
        }
    }

    public void setValues(T value, EnumTolerance enumTol) {
        this.tolerated.clear();
        Tolerance tol = Tolerance.get(enumTol);
        for (Enum full : this.fullSet) {
            if (full.ordinal() > ((Enum)value).ordinal() + tol.getBounds()[1] || full.ordinal() < ((Enum)value).ordinal() + tol.getBounds()[0]) continue;
            this.tolerated.add(full);
        }
    }
}

