/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.BinnieGUIHandler;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import binnie.extrabees.genetics.BeeBreedingSystem;
import binnie.extrabees.genetics.ExtraBeeDefinition;
import binnie.extrabees.genetics.ExtraBeesFlowers;
import binnie.extrabees.genetics.effect.ExtraBeesEffect;
import binnie.extrabees.genetics.gui.analyst.AnalystPagePlugin;
import binnie.extrabees.gui.ExtraBeesGUID;
import binnie.extrabees.init.BlockRegister;
import binnie.extrabees.init.ItemRegister;
import binnie.extrabees.init.RecipeRegister;
import binnie.extrabees.items.ItemHoneyCrystal;
import binnie.extrabees.items.ItemMiscProduct;
import binnie.extrabees.items.types.EnumHoneyComb;
import binnie.extrabees.proxy.ExtraBeesCommonProxy;
import binnie.extrabees.utils.AlvearyMutationHandler;
import binnie.extrabees.utils.MaterialBeehive;
import binnie.extrabees.utils.config.ConfigHandler;
import binnie.extrabees.utils.config.ConfigurationMain;
import binnie.extrabees.worldgen.ExtraBeesWorldGenerator;
import binnie.genetics.api.GeneticsApi;
import com.google.common.collect.Lists;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.recipes.RecipeManagers;
import forestry.core.gui.GuiIdRegistry;
import forestry.core.gui.GuiType;
import forestry.core.proxy.Proxies;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="extrabees", name="Binnie's Extra Bees", dependencies="required-after:binniecore", acceptedMinecraftVersions="[1.12]")
public class ExtraBees {
    public static final String MODID = "extrabees";
    @Mod.Instance(value="extrabees")
    public static ExtraBees instance;
    @SidedProxy(clientSide="binnie.extrabees.proxy.ExtraBeesClientProxy", serverSide="binnie.extrabees.proxy.ExtraBeesCommonProxy")
    public static ExtraBeesCommonProxy proxy;
    public static IBreedingSystem beeBreedingSystem;
    public static ConfigHandler configHandler;
    public static Material materialBeehive;
    public static Block hive;
    public static Block alveary;
    public static Block ectoplasm;
    public static Item comb;
    public static Item propolis;
    public static Item honeyDrop;
    public static ItemHoneyCrystal honeyCrystal;
    public static Item dictionary;
    public static ItemMiscProduct itemMisc;
    public static Item dictionaryBees;

    public ExtraBees() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        materialBeehive = new MaterialBeehive();
        File configFile = new File(event.getModConfigurationDirectory(), "forestry/extrabees/main.conf");
        configHandler = new ConfigHandler(configFile);
        configHandler.addConfigurable(new ConfigurationMain());
        BlockRegister.preInitBlocks();
        ItemRegister.preInitItems();
        try {
            Method m = GuiIdRegistry.class.getDeclaredMethod("registerGuiHandlers", GuiType.class, List.class);
            m.setAccessible(true);
            m.invoke(null, GuiType.Tile, Lists.newArrayList((Object[])new Class[]{TileEntityExtraBeesAlvearyPart.class}));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Proxies.render.registerModels();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new BinnieGUIHandler(ExtraBeesGUID.values()));
        beeBreedingSystem = new BeeBreedingSystem();
        Binnie.GENETICS.registerBreedingSystem(beeBreedingSystem);
        GeneticsApi.registerAnalystPagePlugin(new AnalystPagePlugin());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        configHandler.reload(true);
        EnumHoneyComb.addSubtypes();
        ExtraBeesWorldGenerator extraBeesWorldGenerator = new ExtraBeesWorldGenerator();
        extraBeesWorldGenerator.doInit();
        GameRegistry.registerWorldGenerator((IWorldGenerator)extraBeesWorldGenerator, (int)0);
        ExtraBeesEffect.doInit();
        ExtraBeesFlowers.doInit();
        ExtraBeeDefinition.doInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        BlockRegister.postInitBlocks();
        RecipeRegister.postInitRecipes();
        AlvearyMutationHandler.registerMutationItems();
        RecipeManagers.carpenterManager.addRecipe(100, Binnie.LIQUID.getFluidStack("water", 2000), ItemStack.field_190927_a, new ItemStack(dictionaryBees), new Object[]{"X#X", "YEY", "RDR", Character.valueOf('#'), Blocks.field_150410_aZ, Character.valueOf('X'), Items.field_151043_k, Character.valueOf('Y'), "ingotTin", Character.valueOf('R'), Items.field_151137_ax, Character.valueOf('D'), Items.field_151045_i, Character.valueOf('E'), Items.field_151166_bC});
    }

    @SubscribeEvent
    public void onRegisterSpecies(AlleleSpeciesRegisterEvent<IAlleleBeeSpecies> event) {
        if (event.getRoot() != BeeManager.beeRoot) {
            return;
        }
        ExtraBeeDefinition.doPreInit();
    }

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            ResourceLocation newTotem;
            Item value;
            if (!entry.key.toString().equals("genetics:dictionary") || (value = (Item)ForgeRegistries.ITEMS.getValue(newTotem = new ResourceLocation("extrabees:dictionary"))) == null) continue;
            entry.remap((IForgeRegistryEntry)value);
        }
    }
}

