/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.core.api.genetics.IGene;
import binnie.core.api.genetics.IItemAnalysable;
import binnie.core.genetics.Gene;
import binnie.core.item.ItemCore;
import binnie.core.util.I18N;
import binnie.genetics.CreativeTabGenetics;
import binnie.genetics.Genetics;
import binnie.genetics.api.IItemChargeable;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.genetics.SequencerItem;
import com.google.common.base.Preconditions;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSequence
extends ItemCore
implements IItemAnalysable,
IItemChargeable {
    public ItemSequence() {
        super("sequence");
        this.func_77625_d(1);
        this.func_77656_e(5);
        this.func_77637_a(CreativeTabGenetics.instance);
    }

    public static ItemStack create(IGene gene) {
        return ItemSequence.create(gene, false);
    }

    public static ItemStack create(IGene gene, boolean sequenced) {
        ItemStack item = new ItemStack((Item)Genetics.items().itemSequencer);
        item.func_77964_b(sequenced ? 0 : item.func_77958_k());
        SequencerItem seq = new SequencerItem(gene);
        seq.writeToItem(item);
        return item;
    }

    public String func_77653_i(ItemStack itemstack) {
        GeneItem gene = GeneItem.create(itemstack);
        if (gene == null) {
            return I18N.localise("genetics.item.sequence.corrupted");
        }
        return gene.getBreedingSystem().getDescriptor() + " " + I18N.localise("genetics.item.sequence.name");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(I18N.localise("genetics.item.sequence." + (5 - itemStack.func_77952_i() % 6)));
        SequencerItem gene = SequencerItem.create(itemStack);
        if (gene != null) {
            if (gene.analysed) {
                gene.getInfo(tooltip);
            } else {
                tooltip.add("<" + I18N.localise("genetics.item.sequence.unknown") + ">");
            }
            int seq = gene.sequenced;
            if (seq == 0) {
                tooltip.add(I18N.localise("genetics.item.sequence.unsequenced"));
            } else if (seq < 100) {
                tooltip.add(I18N.localise("genetics.genetics.item.sequence.partially", seq));
            } else {
                tooltip.add(I18N.localise("genetics.item.sequence.sequenced"));
            }
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            IAlleleBeeSpecies species = (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.speciesMeadows");
            Preconditions.checkNotNull((Object)species);
            items.add((Object)ItemSequence.create(new Gene((IAllele)species, (IChromosomeType)EnumBeeChromosome.SPECIES, (ISpeciesRoot)BeeManager.beeRoot), false));
        }
    }

    @Override
    public boolean isAnalysed(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        return seq != null && seq.analysed;
    }

    @Override
    public ItemStack analyse(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        Preconditions.checkNotNull((Object)seq, (Object)"Cannot analyze itemstack that is not a valid item sequence");
        seq.analysed = true;
        seq.writeToItem(stack);
        return stack;
    }

    @Override
    public float getAnalyseTimeMult(ItemStack stack) {
        return 1.0f;
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77958_k() - stack.func_77952_i();
    }

    @Override
    public int getMaxCharges(ItemStack stack) {
        return stack.func_77958_k();
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        SequencerItem seq = SequencerItem.create(stack);
        Preconditions.checkNotNull((Object)seq, (Object)"Cannot getSpeciesRoot from itemstack that is not a valid item sequence");
        return seq.getSpeciesRoot();
    }
}

