/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.models;

import binnie.core.api.block.TileEntityMetadata;
import binnie.core.models.AABBModelBaker;
import binnie.core.models.ModelManager;
import binnie.extratrees.blocks.decor.BlockMultiFence;
import binnie.extratrees.blocks.decor.FenceType;
import binnie.extratrees.wood.WoodManager;
import forestry.api.core.IModelBaker;
import forestry.core.blocks.properties.UnlistedBlockAccess;
import forestry.core.blocks.properties.UnlistedBlockPos;
import forestry.core.models.ModelBlockCached;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class ModelMultiFence
extends ModelBlockCached<BlockMultiFence, Key> {
    public static final float POST_WIDGTH = 0.25f;
    public static final float POST_HEIGHT = 1.0f;
    public static final float SCALE = 0.0625f;

    public ModelMultiFence() {
        super(BlockMultiFence.class);
    }

    protected Key getInventoryKey(ItemStack stack) {
        return new Key(TileEntityMetadata.getItemDamage(stack), false, false, false, false);
    }

    protected Key getWorldKey(IBlockState state) {
        IExtendedBlockState stateExtended = (IExtendedBlockState)state;
        IBlockAccess world = (IBlockAccess)stateExtended.getValue((IUnlistedProperty)UnlistedBlockAccess.BLOCKACCESS);
        BlockPos pos = (BlockPos)stateExtended.getValue((IUnlistedProperty)UnlistedBlockPos.POS);
        int meta = TileEntityMetadata.getTileMetadata(world, pos);
        return new Key(meta, (Boolean)state.func_177229_b((IProperty)BlockFence.field_176528_N), (Boolean)state.func_177229_b((IProperty)BlockFence.field_176525_b), (Boolean)state.func_177229_b((IProperty)BlockFence.field_176526_a), (Boolean)state.func_177229_b((IProperty)BlockFence.field_176527_M));
    }

    protected IBakedModel bakeModel(IBlockState state, Key key, BlockMultiFence block) {
        if (key == null) {
            return null;
        }
        AABBModelBaker baker = new AABBModelBaker();
        this.bakeBlock(block, key, (IModelBaker)baker, false);
        this.blockModel = baker.bakeModel(false);
        this.onCreateModel(this.blockModel);
        return this.blockModel;
    }

    protected IBakedModel bakeModel(ItemStack stack, World world, Key key) {
        if (key == null) {
            return null;
        }
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        if (!this.blockClass.isInstance(block)) {
            return null;
        }
        BlockMultiFence bBlock = (BlockMultiFence)this.blockClass.cast(block);
        AABBModelBaker baker = new AABBModelBaker();
        this.bakeBlock(bBlock, key, (IModelBaker)baker, true);
        baker.setModelState(ModelManager.getDefaultFenceState());
        this.itemModel = baker.bakeModel(true);
        return this.itemModel;
    }

    protected void bakeBlock(BlockMultiFence block, Key key, IModelBaker baker, boolean inventory) {
        AABBModelBaker modelBaker = (AABBModelBaker)baker;
        if (inventory) {
            this.bakeItemModel(block, modelBaker, key);
        } else {
            this.bakeBlockModel(block, modelBaker, key);
        }
    }

    private void bakeItemModel(BlockMultiFence block, AABBModelBaker modelBaker, Key key) {
        int meta = key.meta;
        FenceType type = key.type;
        for (int i = 0; i < 5; ++i) {
            float thickness = 0.125f;
            boolean secondary = false;
            boolean bottomBar = !type.solid;
            float topBarMaxY = 0.9375f;
            float topBarMinY = 0.8125f;
            float bottomBarMaxY = 0.4375f;
            float bottomBarMinY = 0.3125f;
            if (type.size == 2) {
                bottomBarMinY -= 0.25f;
                bottomBarMaxY -= 0.25f;
                topBarMinY -= 0.25f;
                topBarMaxY -= 0.25f;
            }
            if (type.size == 1) {
                bottomBarMinY -= 0.25f;
                bottomBarMaxY -= 0.25f;
            }
            if (type.solid) {
                topBarMinY = bottomBarMinY;
            }
            float minX = 0.4375f;
            float maxX = 0.5625f;
            float minZ = -0.125f;
            float maxZ = 1.125f;
            if (i == 0) {
                modelBaker.setModelBounds(new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 0.25));
            } else if (i == 1) {
                modelBaker.setModelBounds(new AxisAlignedBB(0.375, 0.0, 0.75, 0.625, 1.0, 1.0));
            } else if (i == 2) {
                modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)topBarMinY, (double)minZ, (double)maxX, (double)topBarMaxY, (double)maxZ));
                secondary = true;
            } else if (i == 3) {
                if (!bottomBar) continue;
                modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)bottomBarMinY, (double)minZ, (double)maxX, (double)bottomBarMaxY, (double)maxZ));
                secondary = true;
            } else if (i == 4) {
                if (type.embossed) {
                    minX -= 0.05625f;
                    maxX += 0.05625f;
                    minZ -= 0.0625f;
                    maxZ += 0.0625f;
                    float minY = 0.0f;
                    float maxY = 1.0f;
                    if (type.size != 1 && !type.solid) {
                        minY = bottomBarMinY + 0.125f;
                        maxY = topBarMaxY - 0.125f;
                    } else if (type.size == 1 && type.solid) {
                        minY = bottomBarMinY + 0.125f;
                        maxY = topBarMaxY - 0.125f;
                    } else {
                        minY = 0.375f;
                        maxY = 0.625f;
                    }
                    if (type.solid && type.size == 0) {
                        minY -= 0.0625f;
                        maxY -= 0.0625f;
                    }
                    if (type.solid && type.size == 2) {
                        minY += 0.0625f;
                        maxY += 0.0625f;
                    }
                    modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
                } else {
                    if (type.size != 1 || type.solid) continue;
                    modelBaker.setModelBounds(new AxisAlignedBB((double)minX, 0.4375, (double)minZ, (double)maxX, 0.5625, (double)maxZ));
                    secondary = true;
                }
            }
            modelBaker.addBlockModel(null, block.getSprite(meta, secondary), 0);
        }
    }

    private void bakeBlockModel(BlockMultiFence block, AABBModelBaker modelBaker, Key key) {
        boolean connectAnyZ;
        float minPostPos = 0.375f;
        float maxPostPos = 0.625f;
        int meta = key.meta;
        FenceType fenceType = key.type;
        TextureAtlasSprite primarySprite = block.getSprite(meta, false);
        TextureAtlasSprite secondarySprite = block.getSprite(meta, true);
        modelBaker.setModelBounds(new AxisAlignedBB((double)minPostPos, 0.0, (double)minPostPos, (double)maxPostPos, 1.0, (double)maxPostPos));
        modelBaker.addBlockModel(null, primarySprite, 0);
        boolean connectNegX = key.west;
        boolean connectPosX = key.east;
        boolean connectNegZ = key.north;
        boolean connectPosZ = key.south;
        boolean connectAnyX = connectNegX || connectPosX;
        boolean bl = connectAnyZ = connectNegZ || connectPosZ;
        if (!connectAnyX && !connectAnyZ) {
            connectAnyX = true;
        }
        minPostPos = 0.4375f;
        maxPostPos = 0.5625f;
        float barMinY = 0.75f;
        float barMaxY = 0.9375f;
        float minX = connectNegX ? 0.0f : minPostPos;
        float maxX = connectPosX ? 1.0f : maxPostPos;
        float minZ = connectNegZ ? 0.0f : minPostPos;
        float maxZ = connectPosZ ? 1.0f : maxPostPos;
        boolean renderBottom = true;
        if (fenceType.size == 2) {
            barMaxY -= 0.3125f;
            barMinY -= 0.3125f;
        }
        if (fenceType.solid) {
            renderBottom = false;
            barMinY = fenceType.size == 0 ? 0.375f : 0.0625f;
        }
        float totalMaxY = barMaxY;
        if (connectAnyX) {
            modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos));
            modelBaker.addBlockModel(null, secondarySprite, 0);
        }
        if (connectAnyZ) {
            modelBaker.setModelBounds(new AxisAlignedBB((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ));
            modelBaker.addBlockModel(null, secondarySprite, 0);
        }
        if (renderBottom) {
            barMinY -= 0.375f;
            barMaxY -= 0.375f;
            if (fenceType.size == 1) {
                barMinY += 0.0625f;
            }
            if (connectAnyX) {
                modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos));
                modelBaker.addBlockModel(null, secondarySprite, 0);
            }
            if (connectAnyZ) {
                modelBaker.setModelBounds(new AxisAlignedBB((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ));
                modelBaker.addBlockModel(null, secondarySprite, 0);
            }
            if (fenceType.size == 1) {
                barMinY -= 0.375f;
                barMaxY -= 0.375f;
                barMaxY += 0.0625f;
                if (connectAnyX) {
                    modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)barMinY, (double)minPostPos, (double)maxX, (double)barMaxY, (double)maxPostPos));
                    modelBaker.addBlockModel(null, secondarySprite, 0);
                }
                if (connectAnyZ) {
                    modelBaker.setModelBounds(new AxisAlignedBB((double)minPostPos, (double)barMinY, (double)minZ, (double)maxPostPos, (double)barMaxY, (double)maxZ));
                    modelBaker.addBlockModel(null, secondarySprite, 0);
                }
            }
        }
        float totalMinY = barMinY;
        if (fenceType.embossed) {
            minPostPos -= 0.046875f;
            maxPostPos += 0.046875f;
            float minY = totalMinY + 0.125f;
            float maxY = totalMaxY - 0.125f;
            if (fenceType.size == 1 && !fenceType.solid) {
                minY = 0.375f;
                maxY = 0.625f;
            } else if (fenceType.size == 0 && fenceType.solid) {
                minY -= 0.25f;
                maxY -= 0.25f;
            } else if (fenceType.size == 2 && fenceType.solid) {
                minY += 0.25f;
                maxY += 0.25f;
            }
            if (connectAnyX) {
                modelBaker.setModelBounds(new AxisAlignedBB((double)minX, (double)minY, (double)minPostPos, (double)maxX, (double)maxY, (double)maxPostPos));
                modelBaker.addBlockModel(null, primarySprite, 0);
            }
            if (connectAnyZ) {
                modelBaker.setModelBounds(new AxisAlignedBB((double)minPostPos, (double)minY, (double)minZ, (double)maxPostPos, (double)maxY, (double)maxZ));
                modelBaker.addBlockModel(null, primarySprite, 0);
            }
        }
        modelBaker.setParticleSprite(primarySprite);
    }

    public static class Key {
        boolean west;
        boolean east;
        boolean north;
        boolean south;
        private int meta;
        private FenceType type;

        public Key(int meta, boolean west, boolean east, boolean north, boolean south) {
            this.meta = meta;
            this.type = WoodManager.getFenceType(meta);
            this.west = west;
            this.east = east;
            this.south = south;
            this.north = north;
        }

        public int hashCode() {
            return Integer.hashCode(this.meta) + Boolean.hashCode(this.east) + Boolean.hashCode(this.west) + Boolean.hashCode(this.south) + Boolean.hashCode(this.north);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.meta == this.meta && this.west == key.west && this.south == key.south && this.north == key.north && this.east == key.east;
        }
    }
}

