/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.distillery;

import binnie.core.gui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.extratrees.gui.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.distillery.DistilleryLogic;
import binnie.extratrees.machines.distillery.window.TankValidatorDistilleryInput;
import binnie.extratrees.machines.distillery.window.TankValidatorDistilleryOutput;
import net.minecraft.tileentity.TileEntity;

public class DistilleryMachine
extends ExtraTreeMachine.PackageExtraTreeMachine
implements IMachineInformation {
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;

    public DistilleryMachine() {
        super("distillery", true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.DISTILLERY);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot input = tanks.addTank(0, "input", 5000);
        input.setValidator(new TankValidatorDistilleryInput());
        input.setOutputSides(MachineSide.TopAndBottom);
        TankSlot output = tanks.addTank(1, "output", 5000);
        output.setValidator(new TankValidatorDistilleryOutput());
        output.setReadOnly();
        output.setOutputSides(MachineSide.Sides);
        new ComponentPowerReceptor(machine);
        new DistilleryLogic(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }

    @Override
    public void register() {
    }
}

