/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.gui.analyst;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITitledWidget;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.util.I18N;
import binnie.core.util.TimeUtil;
import binnie.extratrees.genetics.gui.analyst.AnalystPageFruit;
import binnie.extratrees.genetics.gui.analyst.AnalystPageGrowth;
import binnie.extratrees.genetics.gui.analyst.AnalystPageWood;
import binnie.extratrees.modules.ModuleWood;
import binnie.genetics.api.IAnalystPagePlugin;
import binnie.genetics.gui.analyst.AnalystPageBiology;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TreeAnalystPagePlugin
implements IAnalystPagePlugin<ITree> {
    @Override
    public boolean handles(IIndividual individual) {
        return individual instanceof ITree;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addAnalystPages(ITree individual, IWidget parent, IArea pageSize, List<ITitledWidget> analystPages) {
        analystPages.add(new AnalystPageFruit(parent, pageSize, individual));
        analystPages.add(new AnalystPageWood(parent, pageSize, individual));
        analystPages.add(new AnalystPageBiology<ITree>(parent, pageSize, individual, new BiologyPlugin()));
        analystPages.add(new AnalystPageGrowth(parent, pageSize, (IIndividual)individual));
    }

    private static class BiologyPlugin
    implements AnalystPageBiology.IBiologyPlugin<ITree> {
        private BiologyPlugin() {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public int addBiologyPages(ITree tree, IWidget parent, int y) {
            String alleleName = ModuleWood.treeBreedingSystem.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, tree.getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS));
            new ControlTextCentered(parent, y, TextFormatting.ITALIC + I18N.localise("genetics.gui.analyst.biology.sappiness", alleleName)).setColor(parent.getColor());
            y += 20;
            int fertility = (int)(1.0f / tree.getGenome().getFertility());
            if (fertility > 1) {
                new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.biology.fertility.leaves", fertility)).setColor(parent.getColor());
            } else {
                new ControlTextCentered(parent, y, I18N.localise("genetics.gui.analyst.biology.fertility.leaf")).setColor(parent.getColor());
            }
            int butterflySpawn = Math.round(1365.3999f / (tree.getGenome().getSappiness() * tree.getGenome().getYield() * 0.5f));
            new ControlTextCentered(parent, y += 22, I18N.localise("genetics.gui.analyst.biology.mothSpawn.perLeaf", TimeUtil.getTimeString(butterflySpawn))).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 34, I18N.localise("genetics.gui.analyst.biology.plantTypes")).setColor(parent.getColor());
            new ControlTextCentered(parent, y += 12, TextFormatting.ITALIC + tree.getGenome().getPrimary().getPlantType().toString()).setColor(parent.getColor());
            return y;
        }
    }
}

