/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageBranch;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import forestry.api.genetics.IClassification;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PageBranchOverview
extends PageBranch {
    private ControlText branchName;
    private ControlText branchScientific;
    private ControlText branchAuthority;
    private List<ControlText> branchDescription = new ArrayList<ControlText>();

    public PageBranchOverview(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
        this.branchName = new ControlTextCentered((IWidget)this, 8, "");
        this.branchScientific = new ControlTextCentered((IWidget)this, 32, "");
        this.branchAuthority = new ControlTextCentered((IWidget)this, 44, "");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onValueChanged(IClassification branch) {
        void var3_5;
        this.branchName.setValue(TextFormatting.UNDERLINE + I18N.localise("binniecore.gui.database.branch.name", branch.getName()));
        this.branchScientific.setValue(TextFormatting.ITALIC + I18N.localise("binniecore.gui.database.branch.apidae", branch.getScientific()));
        this.branchAuthority.setValue(I18N.localise("binniecore.gui.database.branch.discoveredBy", TextFormatting.BOLD + branch.getMemberSpecies()[0].getAuthority()));
        for (IWidget iWidget : this.branchDescription) {
            this.deleteChild(iWidget);
        }
        this.branchDescription.clear();
        String desc = branch.getDescription();
        if (desc == null || Objects.equals(desc, "") || desc.contains("for.")) {
            desc = I18N.localise("binniecore.gui.database.branch.noDesc");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> descLines = new ArrayList<String>();
        for (String str : desc.split(" ")) {
            if (RenderUtil.getTextWidth(var3_5 + " " + str) > 134) {
                descLines.add(TextFormatting.ITALIC + var3_5.toString() + TextFormatting.RESET);
                StringBuilder stringBuilder2 = new StringBuilder();
            }
            var3_5.append(" ").append(str);
        }
        descLines.add(var3_5.toString());
        int i = 0;
        for (String dLine : descLines) {
            this.branchDescription.add(new ControlTextCentered((IWidget)this, 84 + 12 * i++, dLine));
        }
    }
}

