/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics;

import binnie.core.AbstractMod;
import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.gui.IBinnieGUID;
import binnie.core.network.BinniePacketHandler;
import binnie.core.network.IPacketID;
import binnie.core.proxy.IProxyCore;
import binnie.genetics.api.GeneticsApi;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsPacket;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.gui.analyst.GeneticsProducePlugin;
import binnie.genetics.item.ItemPunnettSquare;
import binnie.genetics.item.ModuleItems;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.sequencer.Sequencer;
import binnie.genetics.proxy.Proxy;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="genetics", name="Binnie's Genetics", dependencies="required-after:binniecore", acceptedMinecraftVersions="[1.12]")
public class Genetics
extends AbstractMod {
    public static final String CHANNEL = "GEN";
    @Mod.Instance(value="genetics")
    public static Genetics instance;
    @SidedProxy(clientSide="binnie.genetics.proxy.ProxyClient", serverSide="binnie.genetics.proxy.ProxyServer")
    public static Proxy proxy;
    @Nullable
    private static ModuleItems items;
    @Nullable
    private static ModuleMachine machine;

    public static ModuleItems items() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static ModuleMachine machine() {
        Preconditions.checkState((machine != null ? 1 : 0) != 0);
        return machine;
    }

    @Override
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        proxy.registerItem(new ItemPunnettSquare());
        super.preInit(evt);
        GeneticsTexture.dnaIcon = Binnie.RESOURCE.getItemSprite(instance, "dna");
        Sequencer.fxSeqA = Binnie.RESOURCE.getBlockSprite(instance, "fx/sequencer.a");
        Sequencer.fxSeqG = Binnie.RESOURCE.getBlockSprite(instance, "fx/sequencer.g");
        Sequencer.fxSeqT = Binnie.RESOURCE.getBlockSprite(instance, "fx/sequencer.t");
        Sequencer.fxSeqC = Binnie.RESOURCE.getBlockSprite(instance, "fx/sequencer.c");
        GeneticsApi.registerProducePlugin(new GeneticsProducePlugin());
    }

    @Override
    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        super.init(evt);
    }

    @Override
    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        super.postInit(evt);
    }

    @Override
    protected void registerModules() {
        items = new ModuleItems();
        this.addModule(items);
        machine = new ModuleMachine();
        this.addModule(machine);
    }

    @Override
    public IBinnieGUID[] getGUIDs() {
        return GeneticsGUI.values();
    }

    @Override
    public IPacketID[] getPacketIDs() {
        return GeneticsPacket.values();
    }

    @Override
    public String getChannel() {
        return CHANNEL;
    }

    @Override
    public IProxyCore getProxy() {
        return proxy;
    }

    @Override
    public String getModID() {
        return "genetics";
    }

    @Override
    protected Class<? extends BinniePacketHandler> getPacketHandler() {
        return PacketHandler.class;
    }

    @Override
    public boolean isAvailable() {
        return BinnieCore.isGeneticsActive();
    }

    public static class PacketHandler
    extends BinniePacketHandler {
        public PacketHandler() {
            super(instance);
        }
    }
}

