/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.blocks;

import binnie.core.api.block.BlockMetadata;
import binnie.core.api.block.TileEntityMetadata;
import binnie.core.util.I18N;
import binnie.extratrees.blocks.BlockCarpentry;
import binnie.extratrees.carpentry.DesignBlock;
import binnie.extratrees.modules.ModuleCarpentry;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCarpentryPanel
extends BlockCarpentry {
    public BlockCarpentryPanel() {
        super("carpentryPanel");
        this.field_149783_u = true;
        this.func_149713_g(0);
    }

    public static boolean isValidPanelPlacement(IBlockAccess world, BlockPos pos, @Nullable EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        pos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid(world, pos, facing.func_176734_d());
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> itemList) {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        DesignBlock block = this.getCarpentryBlock(source, pos);
        switch (block.getFacing()) {
            case DOWN: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
            }
            case NORTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
            }
            case UP: {
                return new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
            }
            case WEST: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
            }
        }
        return field_185505_j;
    }

    @Override
    public AxisAlignedBB getItemBoundingBox() {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    }

    @Override
    public String getDisplayName(ItemStack itemStack) {
        DesignBlock block = ModuleCarpentry.getDesignBlock(this.getDesignSystem(), TileEntityMetadata.getItemDamage(itemStack));
        return I18N.localise("extratrees.block.woodenpanel.name", block.getDesign().getName());
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public DesignBlock getCarpentryBlock(IBlockAccess world, BlockPos pos) {
        return ModuleCarpentry.getCarpentryPanel(this.getDesignSystem(), TileEntityMetadata.getTileMetadata(world, pos));
    }

    @Override
    public int getPlacedMeta(ItemStack item, World world, BlockPos pos, EnumFacing clickedBlock) {
        DesignBlock block = ModuleCarpentry.getCarpentryPanel(this.getDesignSystem(), TileEntityMetadata.getItemDamage(item));
        EnumFacing facing = clickedBlock;
        boolean valid = true;
        if (!BlockCarpentryPanel.isValidPanelPlacement((IBlockAccess)world, pos, facing)) {
            valid = false;
            for (EnumFacing direction : EnumFacing.field_82609_l) {
                if (!BlockCarpentryPanel.isValidPanelPlacement((IBlockAccess)world, pos, direction)) continue;
                facing = direction;
                valid = true;
                break;
            }
        }
        if (!valid) {
            return -1;
        }
        block.setFacing(facing);
        return block.getBlockMetadata(this.getDesignSystem());
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void onNeighborChange(IBlockAccess blockAccess, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(blockAccess, pos, neighbor);
        World world = (World)blockAccess;
        DesignBlock block = this.getCarpentryBlock(blockAccess, pos);
        if (!BlockCarpentryPanel.isValidPanelPlacement(blockAccess, pos, block.getFacing())) {
            NonNullList drops = NonNullList.func_191196_a();
            BlockMetadata.getDrops((NonNullList<ItemStack>)drops, this, blockAccess, pos);
            for (ItemStack stack : drops) {
                BlockCarpentryPanel.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
            }
            world.func_175698_g(pos);
        }
    }
}

