/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.util.I18N;
import binnie.extratrees.modules.ModuleAlcohol;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public enum GlasswareType {
    BEER_MUG(480, 10, 14, " # ", "   ", "   "),
    PINT(600, 6, 20, " # ", " # ", "# #"),
    SNIFTER(510, 14, 11, " # ", "   ", "# #"),
    FLUTE(180, 13, 15, "# #", "# #", "# #"),
    COCKTAIL(240, 20, 8, " # ", "# #", "# #"),
    CORDIAL(60, 15, 7, "###", " # ", "# #"),
    COLLINS(360, 8, 18, " # ", " # ", "   "),
    HIGHBALL(240, 10, 14, " # ", " # ", "###"),
    HURRICANE(450, 10, 18, "   ", "# #", " # "),
    MARGARITA(360, 18, 9, "###", "   ", "# #"),
    OLD_FASHIONED(240, 13, 8, " # ", "   ", "###"),
    WINE(240, 17, 10, " # ", "# #", "   "),
    SHOT(30, 13, 7, "###", " # ", " # "),
    SHERRY(60, 17, 7, " # ", "# #", "###"),
    COUPE(180, 19, 8, " # ", "# #", " # ");

    public static final float SPRITE_PIXELS = 32.0f;
    public static final int MB_PER_GLASS = 100;
    String name;
    float contentBottom;
    float contentHeight;
    private int capacity;
    private ModelResourceLocation modelLocation;
    private String[] recipe;
    private int recipeGlassCost;

    private GlasswareType(int capacity, int contentBottom, int contentHeight, String ... recipe) {
        this.capacity = capacity;
        this.contentBottom = (float)contentBottom / 32.0f;
        this.contentHeight = (float)contentHeight / 32.0f;
        this.recipe = recipe;
        StringBuilder builder = new StringBuilder();
        for (String s : recipe) {
            builder.append(s);
        }
        String recipeString = builder.toString();
        String recipeGlass = recipeString.replaceAll("#", "");
        this.recipeGlassCost = recipeGlass.length() * 100;
        this.name = this.name().toLowerCase(Locale.ENGLISH).replaceAll("_", "");
        this.modelLocation = new ModelResourceLocation("extratrees:glassware/" + this.name, "inventory");
    }

    public String getName() {
        return this.name;
    }

    public String getName(@Nullable String liquid) {
        if (liquid == null) {
            return I18N.localise("extratrees.item.glassware." + this.name);
        }
        return I18N.localise("extratrees.item.glassware." + this.name + ".usage", liquid);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public ModelResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public ItemStack get(int i) {
        return ModuleAlcohol.drink.getStack(this, null);
    }

    public float getContentBottom() {
        return this.contentBottom;
    }

    public float getContentHeight() {
        return this.contentHeight;
    }

    public int getVolume() {
        return this.getCapacity();
    }

    public Object[] getRecipePattern(Item castingItem) {
        return new Object[]{this.recipe, Character.valueOf('#'), castingItem};
    }

    public int getRecipeGlassCost() {
        return this.recipeGlassCost;
    }
}

