/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.inoculator;

import binnie.core.genetics.Gene;
import binnie.genetics.Genetics;
import binnie.genetics.integration.jei.GeneticsJeiPlugin;
import binnie.genetics.integration.jei.inoculator.InoculatorRecipeWrapper;
import binnie.genetics.item.ItemSerum;
import binnie.genetics.machine.inoculator.InoculatorLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class InoculatorRecipeCategory
implements IRecipeCategory<InoculatorRecipeWrapper> {
    private final IDrawableAnimated arrowAnimated = GeneticsJeiPlugin.drawables.createArrowAnimated(56);
    private final boolean splicer;

    public InoculatorRecipeCategory() {
        this(false);
    }

    protected InoculatorRecipeCategory(boolean splicer) {
        this.splicer = splicer;
    }

    public String getUid() {
        return "binnie.genetics.inoculator";
    }

    public String getTitle() {
        return "Inoculation";
    }

    public String getModName() {
        return Genetics.instance.getModID();
    }

    public IDrawable getBackground() {
        return GeneticsJeiPlugin.guiHelper.createBlankDrawable(130, 60);
    }

    public void drawExtras(Minecraft minecraft) {
        IDrawable arrow = GeneticsJeiPlugin.drawables.getArrow();
        arrow.draw(minecraft, 69, 25);
        this.arrowAnimated.draw(minecraft, 69, 25);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InoculatorRecipeWrapper recipeWrapper, IIngredients ingredients) {
        Object focusValue;
        if (!this.splicer) {
            IDrawable tank = GeneticsJeiPlugin.drawables.getTank();
            IDrawable tankOverlay = GeneticsJeiPlugin.drawables.getTankOverlay();
            IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
            fluidStacks.init(0, true, 1, 1, 16, 58, 100, false, tankOverlay);
            fluidStacks.setBackground(0, tank);
            fluidStacks.set(ingredients);
        }
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 22, 0);
        itemStacks.init(1, true, 42, 21);
        itemStacks.init(2, false, 92, 21);
        IDrawableStatic slot = GeneticsJeiPlugin.guiHelper.getSlotDrawable();
        for (int i = 0; i <= 2; ++i) {
            itemStacks.setBackground(i, (IDrawable)slot);
        }
        recipeWrapper.setCurrentIngredients(itemStacks.getGuiIngredients());
        IFocus focus = recipeLayout.getFocus();
        if (focus != null && (focusValue = focus.getValue()) instanceof ItemStack) {
            ItemStack focusStack = (ItemStack)focusValue;
            if (AlleleManager.alleleRegistry.isIndividual(focusStack)) {
                IIndividual individual;
                if (focus.getMode() == IFocus.Mode.INPUT) {
                    ItemStack serum = recipeWrapper.getInputSerum();
                    ItemStack output = InoculatorLogic.applySerum(focusStack, serum);
                    itemStacks.set(0, serum);
                    itemStacks.set(1, focusStack);
                    itemStacks.set(2, output);
                    return;
                }
                if (focus.getMode() == IFocus.Mode.OUTPUT && (individual = AlleleManager.alleleRegistry.getIndividual(focusStack)) != null) {
                    ISpeciesRoot speciesRoot = individual.getGenome().getSpeciesRoot();
                    IAlleleSpecies species = individual.getGenome().getPrimary();
                    ItemStack serum = ItemSerum.create(new Gene((IAllele)species, speciesRoot.getSpeciesChromosomeType(), speciesRoot));
                    serum.func_77964_b(0);
                    itemStacks.set(0, serum);
                    itemStacks.set(1, recipeWrapper.getWildcardTarget());
                    itemStacks.set(2, focusStack);
                    return;
                }
            } else if (focusStack.func_77973_b() instanceof ItemSerum) {
                ItemStack input = recipeWrapper.getWildcardTarget();
                ItemStack output = InoculatorLogic.applySerum(input, focusStack);
                itemStacks.set(0, focusStack);
                itemStacks.set(1, input);
                itemStacks.set(2, output);
                return;
            }
        }
        itemStacks.set(ingredients);
    }
}

