/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.database.bee;

import binnie.core.AbstractMod;
import binnie.core.Binnie;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.genetics.Genetics;
import binnie.genetics.gui.database.bee.PageSpeciesClimate;
import binnie.genetics.gui.database.bee.PageSpeciesGenome;
import binnie.genetics.gui.database.bee.PageSpeciesProducts;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowApiaristDatabase
extends WindowAbstractDatabase {
    public WindowApiaristDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, Binnie.GENETICS.getFirstActiveSystem(), 110);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowApiaristDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.overview"));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.classification"));
        new PageSpeciesGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.genome"));
        new PageSpeciesProducts((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.products"));
        new PageSpeciesClimate((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.climate"));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.resultant"));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(Genetics.instance, "species.further"));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Genetics.instance, "branches.overview"));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(Genetics.instance, "branches.species"));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(Genetics.instance, "breeder"));
    }

    @Override
    public AbstractMod getMod() {
        return Genetics.instance;
    }

    @Override
    public String getBackgroundTextureName() {
        return "Database";
    }

    static enum BranchesTab {
        Overview(255),
        Species(0xFF0000);

        public int color;

        private BranchesTab(int color) {
            this.color = color;
        }
    }

    static enum SpeciesTab {
        Overview(255),
        Genome(0xFFFF00),
        Productivity(65535),
        Climate(0xFF0000),
        ResultantMutations(0xFF00FF),
        FurtherMutations(65280);

        public int color;

        private SpeciesTab(int color) {
            this.color = color;
        }
    }
}

