/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.database.bee;

import binnie.core.BinnieCore;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.genetics.gui.database.bee.ControlProductsItem;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class ControlProductsBox
extends ControlListBox<Product> {
    IAlleleBeeSpecies species = null;
    private int index;
    private Type type;

    public ControlProductsBox(IWidget parent, int x, int y, int width, int height, Type type) {
        super(parent, x, y, width, height, 12);
        this.type = type;
    }

    @Override
    public IWidget createOption(Product value, int y) {
        return new ControlProductsItem((ControlList)this.getContent(), value, y);
    }

    public void setSpecies(IAlleleBeeSpecies species) {
        if (species == this.species || (this.species = species) == null) {
            return;
        }
        IAllele[] template = BeeManager.beeRoot.getTemplate(species.getUID());
        if (template == null) {
            return;
        }
        IBeeGenome genome = BeeManager.beeRoot.templateAsGenome(template);
        float speed = genome.getSpeed();
        float modeSpeed = BeeManager.beeRoot.getBeekeepingMode(BinnieCore.getBinnieProxy().getWorld()).getBeeModifier().getProductionModifier(genome, 1.0f);
        ArrayList<Product> strings = new ArrayList<Product>();
        if (this.type == Type.PRODUCTS) {
            for (Map.Entry entry : species.getProductChances().entrySet()) {
                strings.add(new Product((ItemStack)entry.getKey(), speed * modeSpeed * ((Float)entry.getValue()).floatValue()));
            }
        } else {
            for (Map.Entry entry : species.getSpecialtyChances().entrySet()) {
                strings.add(new Product((ItemStack)entry.getKey(), speed * modeSpeed * ((Float)entry.getValue()).floatValue()));
            }
        }
        this.setOptions(strings);
    }

    class Product {
        ItemStack item;
        float chance;

        public Product(ItemStack item, float chance) {
            this.item = item;
            this.chance = chance;
        }
    }

    static enum Type {
        PRODUCTS,
        SPECIALTIES;

    }
}

