/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.FluidStackUtil;
import binnie.core.util.UniqueFluidStackSet;
import binnie.core.util.UniqueItemStackSet;
import binnie.genetics.api.GeneticsApi;
import binnie.genetics.api.IProducePlugin;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public abstract class AnalystPageProduce
extends ControlAnalystPage {
    public AnalystPageProduce(IWidget parent, IArea area) {
        super(parent, area);
    }

    protected NonNullList<ItemStack> getAllProducts(ItemStack key) {
        NonNullList products = NonNullList.func_191196_a();
        for (IProducePlugin plugin : GeneticsApi.getProducePlugins()) {
            plugin.getItems(key, (NonNullList<ItemStack>)products);
        }
        return products;
    }

    public NonNullList<FluidStack> getAllFluidsFromItems(Collection<ItemStack> itemStacks) {
        NonNullList allFluids = NonNullList.func_191196_a();
        for (ItemStack itemStack : itemStacks) {
            for (IProducePlugin producePlugin : GeneticsApi.getProducePlugins()) {
                producePlugin.getFluids(itemStack, (NonNullList<FluidStack>)allFluids);
            }
        }
        return FluidStackUtil.removeEqualFluids((Collection<FluidStack>)allFluids);
    }

    public NonNullList<FluidStack> getAllFluidsFromFluids(Collection<FluidStack> fluidStacks) {
        NonNullList allFluids = NonNullList.func_191196_a();
        for (FluidStack itemStack : fluidStacks) {
            for (IProducePlugin producePlugin : GeneticsApi.getProducePlugins()) {
                producePlugin.getFluids(itemStack, (NonNullList<FluidStack>)allFluids);
            }
        }
        return FluidStackUtil.removeEqualFluids((Collection<FluidStack>)allFluids);
    }

    protected Collection<ItemStack> getAllProductsAndFluids(Collection<ItemStack> collection) {
        UniqueItemStackSet products = new UniqueItemStackSet();
        for (ItemStack itemStack : collection) {
            products.addAll(this.getAllProducts(itemStack));
        }
        UniqueItemStackSet products2 = new UniqueItemStackSet();
        for (Object stack2 : products) {
            products2.addAll(this.getAllProducts((ItemStack)stack2));
        }
        UniqueItemStackSet uniqueItemStackSet = new UniqueItemStackSet();
        for (ItemStack stack3 : products2) {
            uniqueItemStackSet.addAll(this.getAllProducts(stack3));
        }
        products.addAll(products2);
        products.addAll(uniqueItemStackSet);
        UniqueFluidStackSet allFluids = new UniqueFluidStackSet();
        allFluids.addAll(this.getAllFluidsFromItems(collection));
        UniqueFluidStackSet fluids2 = new UniqueFluidStackSet();
        fluids2.addAll(this.getAllFluidsFromFluids(allFluids));
        UniqueFluidStackSet fluids3 = new UniqueFluidStackSet();
        fluids3.addAll(this.getAllFluidsFromFluids(fluids2));
        allFluids.addAll(fluids2);
        allFluids.addAll(fluids3);
        for (FluidStack fluid : allFluids) {
            ItemStack container = FluidStackUtil.getContainer(fluid);
            if (container == null) continue;
            products.add(container);
        }
        return products;
    }

    protected int getRefined(String string, int y, Collection<ItemStack> products) {
        new ControlTextCentered((IWidget)this, y, string).setColor(this.getColor());
        y += 10;
        int maxBiomePerLine = (this.getWidth() + 2 - 16) / 18;
        int biomeListX = (this.getWidth() - (Math.min(maxBiomePerLine, products.size()) * 18 - 2)) / 2;
        int dx = 0;
        int dy = 0;
        for (ItemStack soilStack : products) {
            if (dx >= 18 * maxBiomePerLine) {
                dx = 0;
                dy += 18;
            }
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)soilStack);
            soilStack.func_190920_e(1);
            ControlItemDisplay display = new ControlItemDisplay((IWidget)this, biomeListX + dx, y + dy, soilStack, fluid == null);
            if (fluid != null) {
                display.addTooltip(fluid.getLocalizedName());
            }
            dx += 18;
        }
        if (dx != 0) {
            dy += 18;
        }
        return y += dy;
    }
}

