/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.PageSpecies;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.util.I18N;
import binnie.extratrees.gui.database.ControlBlockIconDisplay;
import binnie.extratrees.modules.ModuleWood;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.ILeafSpriteProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PageSpeciesTreeGenome
extends PageSpecies {
    public PageSpeciesTreeGenome(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        this.deleteAllChildren();
        IAllele[] template = TreeManager.treeRoot.getTemplate(species.getUID());
        if (template == null) {
            return;
        }
        ITree tree = TreeManager.treeRoot.templateAsIndividual(template);
        ITreeGenome genome = tree.getGenome();
        IAlleleTreeSpecies treeSpecies = genome.getPrimary();
        int w = 144;
        int h = 176;
        new ControlText(this, new Area(0, 4, 144, 16), ((DatabaseTab)this.getValue()).toString(), TextJustification.MIDDLE_CENTER);
        ControlScrollableContent<Control> scrollable = new ControlScrollableContent<Control>(this, 4, 20, 136, 152, 12);
        Control contents = new Control(scrollable, 0, 0, 124, 152);
        int tw = 124;
        int w2 = 65;
        int w3 = 74;
        int y = 0;
        int th = 14;
        int th2 = 18;
        IBreedingSystem syst = ModuleWood.treeBreedingSystem;
        new ControlText(contents, new Area(65, y, 74, 14), treeSpecies.getPlantType().toString(), TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += 14, 65, 14), I18N.localise("binniecore.gui.temperature.short") + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), treeSpecies.getTemperature().getName(), TextJustification.MIDDLE_LEFT);
        y += 14;
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        ILeafSpriteProvider spriteProvider = treeSpecies.getLeafSpriteProvider();
        TextureAtlasSprite leaf = map.func_110572_b(spriteProvider.getSprite(false, false).toString());
        int leafColour = spriteProvider.getColor(false);
        TextureAtlasSprite fruit = null;
        int fruitColour = 0xFFFFFF;
        IFruitProvider fruitProvider = genome.getFruitProvider();
        try {
            fruit = map.func_110572_b(fruitProvider.getSprite(genome, null, BlockPos.field_177992_a, 100).toString());
            fruitColour = fruitProvider.getColour(genome, null, BlockPos.field_177992_a, 100);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (leaf != null) {
            new ControlText(contents, new Area(0, y, 65, 18), I18N.localise("extratrees.gui.database.leaves") + " : ", TextJustification.MIDDLE_RIGHT);
            new ControlBlockIconDisplay(contents, 65, y, leaf).setColor(leafColour);
            if (fruit != null && !treeSpecies.getUID().equals("forestry.treeOak")) {
                new ControlBlockIconDisplay(contents, 65, y, fruit).setColor(fruitColour);
            }
            y += 18;
        }
        Map products = fruitProvider.getProducts();
        ItemStack log = treeSpecies.getWoodProvider().getWoodStack();
        if (log.func_190926_b()) {
            new ControlText(contents, new Area(0, y, 65, 18), I18N.localise("extratrees.gui.database.log") + " : ", TextJustification.MIDDLE_RIGHT);
            ControlItemDisplay display = new ControlItemDisplay(contents, 65, y);
            display.setItemStack(log);
            display.setTooltip();
            y += 18;
        }
        new ControlText(contents, new Area(0, y, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.HEIGHT) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getHeight() + "x", TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += 14, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.FERTILITY) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getFertility() + "x", TextJustification.MIDDLE_LEFT);
        y += 14;
        ArrayList fruits = new ArrayList();
        fruits.addAll(products.keySet());
        if (!fruits.isEmpty()) {
            new ControlText(contents, new Area(0, y, 65, 18), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.FRUITS) + " : ", TextJustification.MIDDLE_RIGHT);
            for (ItemStack fruitw : fruits) {
                ControlItemDisplay display2 = new ControlItemDisplay(contents, 65, y);
                display2.setItemStack(fruitw);
                display2.setTooltip();
                y += 18;
            }
        }
        new ControlText(contents, new Area(0, y, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.YIELD) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getYield() + "x", TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += 14, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.SAPPINESS) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getSappiness() + "x", TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += 14, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.MATURATION) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getMaturationTime() + "x", TextJustification.MIDDLE_LEFT);
        new ControlText(contents, new Area(0, y += 14, 65, 14), syst.getChromosomeShortName((IChromosomeType)EnumTreeChromosome.GIRTH) + " : ", TextJustification.MIDDLE_RIGHT);
        new ControlText(contents, new Area(65, y, 74, 14), genome.getGirth() + "x" + genome.getGirth(), TextJustification.MIDDLE_LEFT);
        contents.setSize(new Point(contents.getSize().xPos(), y += 14));
        scrollable.setScrollableContent(contents);
    }
}

