/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.network.packet;

import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.MessageBinnie;
import binnie.core.network.packet.MessageCoordinates;
import binnie.core.network.packet.PacketPayload;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;

public class MessageUpdate
extends MessageCoordinates {
    @Nullable
    public PacketPayload payload;

    public MessageUpdate(MessageBinnie message) {
        super(message);
    }

    public MessageUpdate(int id, INetworkedEntity tile) {
        super(id, ((TileEntity)tile).func_174877_v());
        this.payload = new PacketPayload();
        tile.writeToPacket(this.payload);
    }

    @Override
    public void writeData(ByteBuf data) throws IOException {
        super.writeData(data);
        if (this.payload == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
            return;
        }
        data.writeInt(this.payload.getIntPayload().size());
        data.writeInt(this.payload.getFloatPayload().size());
        data.writeInt(this.payload.getStringPayload().size());
        Iterator<Object> iterator = this.payload.getIntPayload().iterator();
        while (iterator.hasNext()) {
            int intData = iterator.next();
            data.writeInt(intData);
        }
        iterator = this.payload.getFloatPayload().iterator();
        while (iterator.hasNext()) {
            float floatData = ((Float)iterator.next()).floatValue();
            data.writeFloat(floatData);
        }
        for (String stringData : this.payload.getStringPayload()) {
            byte[] bytes = stringData.getBytes("UTF-8");
            data.writeShort(bytes.length);
            data.writeBytes(bytes);
        }
    }

    @Override
    public void readData(ByteBuf data) throws IOException {
        int i;
        super.readData(data);
        this.payload = new PacketPayload();
        int intLength = data.readInt();
        int floatLength = data.readInt();
        int stringLength = data.readInt();
        this.payload.getIntPayload().clear();
        this.payload.getFloatPayload().clear();
        this.payload.getStringPayload().clear();
        for (i = 0; i < intLength; ++i) {
            this.payload.addInteger(data.readInt());
        }
        for (i = 0; i < floatLength; ++i) {
            this.payload.addFloat(data.readFloat());
        }
        for (i = 0; i < stringLength; ++i) {
            short length = data.readShort();
            byte[] string = data.readBytes((int)length).array();
            this.payload.addString(new String(string, "UTF-8"));
        }
    }
}

