/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.modules;

import binnie.core.modules.BinnieModule;
import binnie.core.modules.Module;
import forestry.core.utils.Log;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;

public class ModuleHelper {
    private ModuleHelper() {
    }

    public static Map<String, List<Module>> getModules(ASMDataTable asmDataTable) {
        String annotationClassName = BinnieModule.class.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        ArrayList<Module> instances = new ArrayList<Module>();
        for (ASMDataTable.ASMData asmData : asmDatas) {
            try {
                Class<?> asmClass = Class.forName(asmData.getClassName());
                Class<Module> asmInstanceClass = asmClass.asSubclass(Module.class);
                Module instance = asmInstanceClass.newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                Log.error((String)"Failed to load: {}", (Object[])new Object[]{asmData.getClassName(), e});
            }
        }
        LinkedHashMap<String, List<Module>> modules = new LinkedHashMap<String, List<Module>>();
        for (Module module : instances) {
            BinnieModule info = module.getClass().getAnnotation(BinnieModule.class);
            modules.computeIfAbsent(info.moduleContainerID(), k -> new ArrayList()).add(module);
        }
        return modules;
    }
}

