/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlEnergyBar
extends Control
implements ITooltip {
    public static boolean isError;
    private Alignment direction;

    public ControlEnergyBar(IWidget parent, int x, int y, int width, int height, Alignment direction) {
        super(parent, x, y, width, height);
        this.direction = direction;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Nullable
    public IPoweredMachine getClientPower() {
        TileEntityMachine machine;
        IInventory inventory = ((Window)Window.get(this)).getInventory();
        TileEntityMachine tileEntityMachine = machine = inventory instanceof TileEntityMachine ? (TileEntityMachine)inventory : null;
        if (machine == null) {
            return null;
        }
        return machine.getMachine().getInterface(IPoweredMachine.class);
    }

    public float getPercentage() {
        float percentage = 100.0f * this.getStoredEnergy() / this.getMaxEnergy();
        if (percentage > 100.0f) {
            percentage = 100.0f;
        }
        return percentage;
    }

    private float getStoredEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getStoredEnergy();
    }

    private float getMaxEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getMaxEnergy();
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add((int)this.getPercentage() + "% charged");
        tooltip.add(this.getStoredEnergy() + "/" + this.getMaxEnergy() + " RF");
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        tooltip.add("Energy Bar");
        tooltip.add("Current: " + this.getStoredEnergy() + " RF (" + (int)this.getPercentage() + "%)");
        tooltip.add("Capacity: " + this.getMaxEnergy() + " RF");
        IProcess process = Machine.getInterface(IProcess.class, ((Window)Window.get(this)).getInventory());
        if (process != null) {
            tooltip.add("Usage: " + (int)process.getEnergyPerTick() + " RF");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        int c;
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_BACK, this.getArea());
        float percentage = this.getPercentage() / 100.0f;
        int colourFromPercentage = this.getColourFromPercentage(percentage);
        RenderUtil.setColour(colourFromPercentage);
        IArea area = this.getArea();
        switch (this.direction) {
            case TOP: 
            case BOTTOM: {
                int height = Math.round((float)area.size().yPos() * percentage);
                area.setSize(new Point(area.size().xPos(), height));
                break;
            }
            case LEFT: 
            case RIGHT: {
                int width = Math.round((float)area.size().xPos() * percentage);
                area.setSize(new Point(width, area.size().yPos()));
                break;
            }
        }
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.HELP);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        } else if (isError) {
            c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR);
            RenderUtil.drawGradientRect(this.getArea().inset(1), c, c);
        }
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_GLOW, area);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        CraftGUI.RENDER.texture((Object)CraftGUITexture.ENERGY_BAR_GLASS, this.getArea());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().isHelpMode()) {
            IArea area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(Tooltip.Type.HELP));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        } else if (isError) {
            IArea area = this.getArea();
            RenderUtil.setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.ERROR));
            CraftGUI.RENDER.texture((Object)CraftGUITexture.OUTLINE, area.outset(1));
        }
    }

    public int getColourFromPercentage(float percentage) {
        if ((double)percentage > 0.5) {
            int r = (int)((1.0 - 2.0 * ((double)percentage - 0.5)) * 255.0);
            return (r << 16) + 65280;
        }
        int g = (int)(255.0f * (2.0f * percentage));
        return 0xFF0000 + (g << 8);
    }
}

