/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.Tooltip;
import binnie.core.gui.database.EnumDiscoveryState;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlIndividualDisplay
extends ControlItemDisplay
implements ITooltip {
    private EnumDiscoveryState discovered = EnumDiscoveryState.SHOW;
    @Nullable
    private IAlleleSpecies species = null;

    public ControlIndividualDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlIndividualDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size);
        this.addSelfEventHandler(EventMouse.Down.class, event -> {
            if (event.getButton() == 0 && this.species != null && EnumDiscoveryState.SHOW == this.discovered) {
                ((WindowAbstractDatabase)this.getTopParent()).gotoSpeciesDelayed(this.species);
            }
        });
    }

    public void setSpecies(IAlleleSpecies species) {
        this.setSpecies(species, EnumDiscoveryState.SHOW);
    }

    public void setSpecies(IAlleleSpecies species, EnumDiscoveryState state) {
        ISpeciesRoot speciesRoot = Binnie.GENETICS.getSpeciesRoot(species);
        IBreedingSystem system = Binnie.GENETICS.getSystem(speciesRoot);
        IAllele[] template = system.getSpeciesRoot().getTemplate(species);
        IIndividual ind = system.getSpeciesRoot().templateAsIndividual(template);
        super.setItemStack(system.getSpeciesRoot().getMemberStack(ind, system.getDefaultType()));
        this.species = species;
        GameProfile username = ((Window)Window.get(this)).getUsername();
        if (state == EnumDiscoveryState.UNDETERMINED) {
            EnumDiscoveryState enumDiscoveryState = state = system.isSpeciesDiscovered(species, ((Window)Window.get(this)).getWorld(), username) ? EnumDiscoveryState.DISCOVERED : EnumDiscoveryState.UNDISCOVERED;
        }
        if (Window.get(this) instanceof WindowAbstractDatabase && ((WindowAbstractDatabase)Window.get((IWidget)this)).isNEI) {
            state = EnumDiscoveryState.SHOW;
        }
        this.discovered = state;
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderForeground(int guiWidth, int guiHeight) {
        TextureAtlasSprite icon = null;
        if (this.species == null) {
            return;
        }
        IBreedingSystem system = Binnie.GENETICS.getSystem(this.species.getRoot());
        switch (this.discovered) {
            case SHOW: {
                super.onRenderForeground(guiWidth, guiHeight);
                return;
            }
            case DISCOVERED: {
                icon = system.getDiscoveredIcon();
                break;
            }
            case UNDISCOVERED: {
                icon = system.getUndiscoveredIcon();
            }
        }
        if (icon != null) {
            RenderUtil.drawGuiSprite(Point.ZERO, icon);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        if (this.species != null) {
            switch (this.discovered) {
                case SHOW: {
                    tooltip.add(this.species.getAlleleName());
                    break;
                }
                case DISCOVERED: {
                    tooltip.add(I18N.localise("binniecore.gui.database.discovered.discovered"));
                    break;
                }
                case UNDISCOVERED: {
                    tooltip.add(I18N.localise("binniecore.gui.database.discovered.undiscovered"));
                }
            }
        }
    }

    public void setDiscovered(EnumDiscoveryState discovered) {
        this.discovered = discovered;
    }

    public EnumDiscoveryState getDiscovered() {
        return this.discovered;
    }
}

