/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.core;

import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.ITooltip;
import binnie.core.gui.ITooltipHelp;
import binnie.core.gui.Tooltip;
import binnie.core.gui.Widget;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Control
extends Widget
implements ITooltipHelp,
ITooltip {
    public int extraLevel = 0;
    private List<String> helpStrings = new ArrayList<String>();
    private List<String> tooltipStrings = new ArrayList<String>();

    public Control(IWidget parent, int xPos, int yPos, int width, int height) {
        super(parent);
        this.setPosition(new Point(xPos, yPos));
        this.setSize(new Point(width, height));
        this.initialise();
    }

    public Control(IWidget parent, IArea area) {
        this(parent, area.xPos(), area.yPos(), area.width(), area.height());
    }

    protected void initialise() {
    }

    @Override
    @Nonnull
    public IWidget getParent() {
        return super.getParent();
    }

    public void addHelp(String string) {
        this.helpStrings.add(string);
    }

    public void addHelp(String[] strings) {
        for (String string : strings) {
            this.addHelp(string);
        }
    }

    public void addTooltip(String string) {
        this.addAttribute(Attribute.MOUSE_OVER);
        this.tooltipStrings.add(string);
    }

    public void addTooltip(String[] strings) {
        for (String string : strings) {
            this.addTooltip(string);
        }
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        tooltip.add(this.helpStrings);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(this.tooltipStrings);
    }

    public Window getWindow() {
        return (Window)this.getTopParent();
    }
}

