/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.WindowAnalyst;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlAnalystButton
extends Control {
    ControlAnalystPage value;
    WindowAnalyst window;

    public ControlAnalystButton(IWidget parent, int x, int y, int width, int height, WindowAnalyst window, ControlAnalystPage page) {
        super(parent, x, y, width, height);
        this.window = window;
        this.addAttribute(Attribute.MOUSE_OVER);
        this.value = page;
        this.addSelfEventHandler(EventMouse.Down.class, event -> {
            List<ControlAnalystPage> pages = window.analystPages;
            int currentIndex = pages.indexOf(window.rightPage.getContent());
            int clickedIndex = pages.indexOf(this.value);
            if (window.isDatabase) {
                if (clickedIndex != 0 && clickedIndex != currentIndex) {
                    window.setPage(window.rightPage, this.value);
                }
            } else {
                if (clickedIndex < 0) {
                    clickedIndex = 0;
                }
                if (clickedIndex < currentIndex) {
                    ++clickedIndex;
                }
                window.setPage(window.rightPage, null);
                window.setPage(window.leftPage, null);
                window.setPage(window.rightPage, pages.get(clickedIndex));
                window.setPage(window.leftPage, pages.get(clickedIndex - 1));
            }
        });
    }

    @Override
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        tooltip.add(this.value.getTitle());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        boolean active = this.value == this.window.leftPage.getContent() || this.value == this.window.rightPage.getContent();
        RenderUtil.setColour((active ? -16777216 : 0x44000000) + this.value.getColor());
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_SOLID, this.getArea().inset(1));
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderUtil.setColour(this.value.getColor());
        CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_OUTLINE, this.getArea().inset(1));
        super.onRenderBackground(guiWidth, guiHeight);
    }
}

