/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.modules;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.block.ItemMetadata;
import binnie.core.liquid.ILiquidDefinition;
import binnie.core.models.DoublePassBakedModel;
import binnie.core.modules.BinnieModule;
import binnie.core.modules.Module;
import binnie.core.util.RecipeUtil;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.blocks.BlockETDecorativeLeaves;
import binnie.extratrees.blocks.BlockETDefaultLeaves;
import binnie.extratrees.blocks.decor.BlockMultiFence;
import binnie.extratrees.blocks.decor.MultiFenceRecipeEmbedded;
import binnie.extratrees.blocks.decor.MultiFenceRecipeSize;
import binnie.extratrees.blocks.decor.MultiFenceRecipeSolid;
import binnie.extratrees.blocks.property.PropertyETType;
import binnie.extratrees.blocks.wood.BlockETDoor;
import binnie.extratrees.blocks.wood.BlockETFence;
import binnie.extratrees.blocks.wood.BlockETLog;
import binnie.extratrees.blocks.wood.BlockETPlank;
import binnie.extratrees.blocks.wood.BlockETSlab;
import binnie.extratrees.blocks.wood.BlockShrubLog;
import binnie.extratrees.blocks.wood.ItemBlockETWood;
import binnie.extratrees.blocks.wood.ItemBlockETWoodDoor;
import binnie.extratrees.blocks.wood.ItemETSlab;
import binnie.extratrees.genetics.AlleleETFruit;
import binnie.extratrees.genetics.ButterflySpecies;
import binnie.extratrees.genetics.ETTreeDefinition;
import binnie.extratrees.genetics.ExtraTreeMutation;
import binnie.extratrees.genetics.FruitSprite;
import binnie.extratrees.genetics.TreeBreedingSystem;
import binnie.extratrees.items.ExtraTreeLiquid;
import binnie.extratrees.items.ItemBlockETDecorativeLeaves;
import binnie.extratrees.wood.EnumETLog;
import binnie.extratrees.wood.EnumShrubLog;
import binnie.extratrees.wood.WoodManager;
import binnie.extratrees.wood.planks.ExtraTreePlanks;
import binnie.extratrees.wood.planks.ForestryPlanks;
import binnie.extratrees.wood.planks.IPlankType;
import binnie.extratrees.wood.planks.VanillaPlanks;
import com.google.common.base.Preconditions;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.arboriculture.IWoodAccess;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.AlleleRegisterEvent;
import forestry.api.genetics.AlleleSpeciesRegisterEvent;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.recipes.RecipeManagers;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.PluginArboriculture;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockForestryFenceGate;
import forestry.arboriculture.blocks.BlockForestryStairs;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.core.fluids.Fluids;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

@BinnieModule(moduleID="extratrees.wood", moduleContainerID="extratrees", name="Wood", unlocalizedDescription="extratrees.module.wood")
public class ModuleWood
extends Module {
    public static List<BlockETLog> logs = new ArrayList<BlockETLog>();
    public static List<BlockETLog> logsFireproof = new ArrayList<BlockETLog>();
    public static List<BlockETPlank> planks = new ArrayList<BlockETPlank>();
    public static List<BlockETPlank> planksFireproof = new ArrayList<BlockETPlank>();
    public static List<BlockETSlab> slabs = new ArrayList<BlockETSlab>();
    public static List<BlockETSlab> slabsDouble = new ArrayList<BlockETSlab>();
    public static List<BlockETSlab> slabsFireproof = new ArrayList<BlockETSlab>();
    public static List<BlockETSlab> slabsDoubleFireproof = new ArrayList<BlockETSlab>();
    public static List<BlockForestryStairs<EnumETLog>> stairs = new ArrayList<BlockForestryStairs<EnumETLog>>();
    public static List<BlockForestryStairs<EnumETLog>> stairsFireproof = new ArrayList<BlockForestryStairs<EnumETLog>>();
    public static List<BlockETFence> fences = new ArrayList<BlockETFence>();
    public static List<BlockETFence> fencesFireproof = new ArrayList<BlockETFence>();
    public static List<BlockForestryFenceGate<EnumETLog>> fenceGates = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
    public static List<BlockForestryFenceGate<EnumETLog>> fenceGatesFireproof = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
    public static List<BlockETDoor> doors = new ArrayList<BlockETDoor>();
    public static List<BlockETDecorativeLeaves> leavesDecorative = new ArrayList<BlockETDecorativeLeaves>();
    public static Map<String, ItemStack> speciesToLeavesDecorative = new HashMap<String, ItemStack>();
    public static List<BlockETDefaultLeaves> leavesDefault = new ArrayList<BlockETDefaultLeaves>();
    @Nullable
    public static BlockMultiFence blockMultiFence;
    @Nullable
    public static BlockShrubLog shrubLog;
    public static IBreedingSystem treeBreedingSystem;
    public static String[] branches;
    public static List<List<String>> classifications;

    private static void registerOreDictWildcard(String oreDictName, Block block) {
        OreDictionary.registerOre((String)oreDictName, (ItemStack)new ItemStack(block, 1, Short.MAX_VALUE));
    }

    public static ItemStack getDecorativeLeaves(String speciesUid) {
        ItemStack itemStack = speciesToLeavesDecorative.get(speciesUid);
        return itemStack.func_77946_l();
    }

    @Override
    public void preInit() {
        String speciesUid;
        String name;
        BlockForestryStairs stair;
        EnumETLog woodType;
        int meta;
        BlockETSlab slabDouble;
        int i;
        MinecraftForge.EVENT_BUS.register((Object)this);
        WoodAccess woodAccess = WoodAccess.getInstance();
        ModuleWood.registerPlanks();
        logs = BlockETLog.create(false);
        logsFireproof = BlockETLog.create(true);
        for (BlockETLog blockETLog : logs) {
            ExtraTrees.proxy.registerBlock(blockETLog, (ItemBlock)new ItemBlockETWood<BlockETLog>(blockETLog));
            ModuleWood.registerOreDictWildcard("logWood", (Block)blockETLog);
        }
        logsFireproof = BlockETLog.create(true);
        for (BlockETLog blockETLog : logsFireproof) {
            ExtraTrees.proxy.registerBlock(blockETLog, (ItemBlock)new ItemBlockETWood<BlockETLog>(blockETLog));
            ModuleWood.registerOreDictWildcard("logWood", (Block)blockETLog);
        }
        woodAccess.registerLogs(logs);
        woodAccess.registerLogs(logsFireproof);
        planks = BlockETPlank.create(false);
        for (BlockETPlank blockETPlank : planks) {
            ExtraTrees.proxy.registerBlock(blockETPlank, (ItemBlock)new ItemBlockETWood<BlockETPlank>(blockETPlank));
            ModuleWood.registerOreDictWildcard("plankWood", (Block)blockETPlank);
        }
        planksFireproof = BlockETPlank.create(true);
        for (BlockETPlank blockETPlank : planksFireproof) {
            ExtraTrees.proxy.registerBlock(blockETPlank, (ItemBlock)new ItemBlockETWood<BlockETPlank>(blockETPlank));
            ModuleWood.registerOreDictWildcard("plankWood", (Block)blockETPlank);
        }
        woodAccess.registerPlanks(planks);
        woodAccess.registerPlanks(planksFireproof);
        slabs = BlockETSlab.create(false, false);
        slabsDouble = BlockETSlab.create(false, true);
        for (i = 0; i < slabs.size(); ++i) {
            BlockETSlab blockETSlab = slabs.get(i);
            slabDouble = slabsDouble.get(i);
            ExtraTrees.proxy.registerBlock(blockETSlab, (ItemBlock)new ItemETSlab(blockETSlab, blockETSlab, slabDouble));
            ExtraTrees.proxy.registerBlock(slabDouble, (ItemBlock)new ItemETSlab(slabDouble, blockETSlab, slabDouble));
            ModuleWood.registerOreDictWildcard("slabWood", (Block)blockETSlab);
        }
        slabsFireproof = BlockETSlab.create(true, false);
        slabsDoubleFireproof = BlockETSlab.create(true, true);
        for (i = 0; i < slabsFireproof.size(); ++i) {
            BlockETSlab blockETSlab = slabsFireproof.get(i);
            slabDouble = slabsDoubleFireproof.get(i);
            ExtraTrees.proxy.registerBlock(blockETSlab, (ItemBlock)new ItemETSlab(blockETSlab, blockETSlab, slabDouble));
            ExtraTrees.proxy.registerBlock(slabDouble, (ItemBlock)new ItemETSlab(slabDouble, blockETSlab, slabDouble));
            ModuleWood.registerOreDictWildcard("slabWood", (Block)blockETSlab);
        }
        woodAccess.registerSlabs(slabs);
        woodAccess.registerSlabs(slabsFireproof);
        stairs = new ArrayList<BlockForestryStairs<EnumETLog>>();
        for (BlockETPlank blockETPlank : planks) {
            for (IBlockState iBlockState : blockETPlank.func_176194_O().func_177619_a()) {
                meta = blockETPlank.func_176201_c(iBlockState);
                woodType = blockETPlank.getWoodType(meta);
                stair = new BlockForestryStairs(false, iBlockState, (Enum)woodType);
                name = "stairs." + (Object)((Object)woodType);
                stair.setRegistryName(new ResourceLocation("extratrees", name));
                stair.func_149663_c(name);
                ExtraTrees.proxy.registerBlock(stair, (ItemBlock)new ItemBlockETWood<BlockForestryStairs>(stair));
                stairs.add((BlockForestryStairs<EnumETLog>)stair);
                ModuleWood.registerOreDictWildcard("stairWood", (Block)stair);
            }
        }
        stairsFireproof = new ArrayList<BlockForestryStairs<EnumETLog>>();
        for (BlockETPlank blockETPlank : planksFireproof) {
            for (IBlockState iBlockState : blockETPlank.func_176194_O().func_177619_a()) {
                meta = blockETPlank.func_176201_c(iBlockState);
                woodType = blockETPlank.getWoodType(meta);
                stair = new BlockForestryStairs(true, iBlockState, (Enum)woodType);
                name = "stairs.fireproof." + (Object)((Object)woodType);
                stair.setRegistryName(new ResourceLocation("extratrees", name));
                stair.func_149663_c(name);
                ExtraTrees.proxy.registerBlock(stair, (ItemBlock)new ItemBlockETWood<BlockForestryStairs>(stair));
                stairsFireproof.add((BlockForestryStairs<EnumETLog>)stair);
                ModuleWood.registerOreDictWildcard("stairWood", (Block)stair);
            }
        }
        woodAccess.registerStairs(stairs);
        woodAccess.registerStairs(stairsFireproof);
        fences = BlockETFence.create(false);
        for (BlockETFence blockETFence : fences) {
            ExtraTrees.proxy.registerBlock(blockETFence, (ItemBlock)new ItemBlockETWood<BlockETFence>(blockETFence));
            ModuleWood.registerOreDictWildcard("fenceWood", (Block)blockETFence);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)blockETFence.getRegistryName().toString());
        }
        fencesFireproof = BlockETFence.create(true);
        for (BlockETFence blockETFence : fencesFireproof) {
            ExtraTrees.proxy.registerBlock(blockETFence, (ItemBlock)new ItemBlockETWood<BlockETFence>(blockETFence));
            ModuleWood.registerOreDictWildcard("fenceWood", (Block)blockETFence);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)blockETFence.getRegistryName().toString());
        }
        woodAccess.registerFences(fences);
        woodAccess.registerFences(fencesFireproof);
        fenceGates = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
        fenceGatesFireproof = new ArrayList<BlockForestryFenceGate<EnumETLog>>();
        for (Iterator<Object> iterator : ExtraTreePlanks.VALUES) {
            EnumETLog woodType2 = ((ExtraTreePlanks)((Object)iterator)).getWoodType();
            BlockForestryFenceGate fenceGate = new BlockForestryFenceGate(false, (Enum)woodType2);
            String name2 = "fence.gates." + (Object)((Object)woodType2);
            fenceGate.setRegistryName(new ResourceLocation("extratrees", name2));
            fenceGate.func_149663_c(name2);
            ExtraTrees.proxy.registerBlock(fenceGate, (ItemBlock)new ItemBlockETWood<BlockForestryFenceGate>(fenceGate));
            ModuleWood.registerOreDictWildcard("fenceGateWood", (Block)fenceGate);
            fenceGates.add((BlockForestryFenceGate<EnumETLog>)fenceGate);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)fenceGate.getRegistryName().toString());
            BlockForestryFenceGate fenceGateFireproof = new BlockForestryFenceGate(true, (Enum)woodType2);
            String nameFireproof = "fence.gates.fireproof." + (Object)((Object)woodType2);
            fenceGateFireproof.setRegistryName(new ResourceLocation("extratrees", nameFireproof));
            fenceGateFireproof.func_149663_c(nameFireproof);
            ExtraTrees.proxy.registerBlock(fenceGateFireproof, (ItemBlock)new ItemBlockETWood<BlockForestryFenceGate>(fenceGateFireproof));
            ModuleWood.registerOreDictWildcard("fenceGateWood", (Block)fenceGateFireproof);
            fenceGatesFireproof.add((BlockForestryFenceGate<EnumETLog>)fenceGateFireproof);
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-fence-block", (String)fenceGateFireproof.getRegistryName().toString());
        }
        woodAccess.registerFenceGates(new ArrayList<BlockForestryFenceGate<EnumETLog>>(fenceGates));
        woodAccess.registerFenceGates(new ArrayList<BlockForestryFenceGate<EnumETLog>>(fenceGatesFireproof));
        doors = new ArrayList<BlockETDoor>();
        for (Iterator<Object> iterator : EnumETLog.VALUES) {
            if (!((EnumETLog)((Object)iterator)).hasProducts()) continue;
            BlockETDoor door = new BlockETDoor((EnumETLog)((Object)iterator));
            ExtraTrees.proxy.registerBlock(door, (ItemBlock)new ItemBlockETWoodDoor(door));
            ModuleWood.registerOreDictWildcard("doorWood", (Block)door);
            doors.add(door);
        }
        this.registerDoors(woodAccess, doors);
        blockMultiFence = new BlockMultiFence();
        ExtraTrees.proxy.registerBlock(blockMultiFence, (ItemBlock)new ItemMetadata((Block)blockMultiFence));
        leavesDefault = BlockETDefaultLeaves.create();
        Map speciesToLeavesDefault = PluginArboriculture.getBlocks().speciesToLeavesDefault;
        for (BlockETDefaultLeaves leaves : leavesDefault) {
            ExtraTrees.proxy.registerBlock(leaves, (ItemBlock)new ItemBlockLeaves((Block)leaves));
            ModuleWood.registerOreDictWildcard("treeLeaves", (Block)leaves);
            PropertyETType propertyETType = leaves.getVariant();
            for (ETTreeDefinition treeDefinition : propertyETType.func_177700_c()) {
                Preconditions.checkNotNull((Object)((Object)treeDefinition));
                speciesUid = treeDefinition.getUID();
                IBlockState blockState = leaves.func_176223_P().func_177226_a((IProperty)propertyETType, (Comparable)((Object)treeDefinition));
                speciesToLeavesDefault.put(speciesUid, blockState);
            }
        }
        leavesDecorative = BlockETDecorativeLeaves.create();
        speciesToLeavesDecorative = new HashMap<String, ItemStack>();
        for (BlockETDecorativeLeaves leaves : leavesDecorative) {
            ExtraTrees.proxy.registerBlock(leaves, (ItemBlock)new ItemBlockETDecorativeLeaves(leaves));
            ModuleWood.registerOreDictWildcard("treeLeaves", leaves);
            for (IBlockState state : leaves.func_176194_O().func_177619_a()) {
                ETTreeDefinition treeDefinition;
                treeDefinition = (ETTreeDefinition)((Object)state.func_177229_b((IProperty)leaves.getVariant()));
                speciesUid = treeDefinition.getUID();
                int meta2 = leaves.func_176201_c(state);
                speciesToLeavesDecorative.put(speciesUid, new ItemStack((Block)leaves, 1, meta2));
            }
        }
        shrubLog = new BlockShrubLog();
        ExtraTrees.proxy.registerBlock(shrubLog, (ItemBlock)new ItemBlockETWood<BlockShrubLog>(shrubLog));
        woodAccess.register((IWoodType)EnumShrubLog.INSTANCE, WoodBlockKind.LOG, false, shrubLog.func_176203_a(0), new ItemStack((Block)shrubLog, 1, 0));
        woodAccess.register((IWoodType)EnumShrubLog.INSTANCE, WoodBlockKind.LOG, true, shrubLog.func_176203_a(1), new ItemStack((Block)shrubLog, 1, 1));
        treeBreedingSystem = new TreeBreedingSystem();
        Binnie.GENETICS.registerBreedingSystem(treeBreedingSystem);
    }

    public static void registerPlanks() {
        for (VanillaPlanks vanillaPlanks : VanillaPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(vanillaPlanks.ordinal(), vanillaPlanks);
        }
        for (Enum enum_ : ExtraTreePlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 32, (IDesignMaterial)((Object)enum_));
        }
        for (Enum enum_ : ForestryPlanks.values()) {
            CarpentryManager.carpentryInterface.registerCarpentryWood(enum_.ordinal() + 128, (IDesignMaterial)((Object)enum_));
        }
    }

    private void registerDoors(WoodAccess woodAccess, List<BlockETDoor> blocks) {
        for (BlockETDoor block : blocks) {
            this.registerWithoutVariants(woodAccess, block, WoodBlockKind.DOOR);
        }
    }

    private <T extends Block> void registerWithoutVariants(WoodAccess woodAccess, T woodTyped, WoodBlockKind woodBlockKind) {
        boolean fireproof = ((IWoodTyped)woodTyped).isFireproof();
        IBlockState blockState = woodTyped.func_176223_P();
        IWoodType woodType = ((IWoodTyped)woodTyped).getWoodType(0);
        ItemStack itemStack = new ItemStack(woodTyped);
        if (!(woodType instanceof EnumVanillaWoodType)) {
            PluginArboriculture.proxy.registerWoodModel(woodTyped, false);
        }
        woodAccess.register(woodType, woodBlockKind, fireproof, blockState, itemStack);
    }

    @Override
    public void init() {
        AlleleETFruit.init();
        ETTreeDefinition.initTrees();
        ExtraTreeMutation.init();
        if (BinnieCore.isLepidopteryActive()) {
            ButterflySpecies.initButterflies();
        }
    }

    @Override
    public void postInit() {
        RecipeUtil recipeUtil = new RecipeUtil("extratrees");
        for (BlockETLog log : logs) {
            ItemStack logInput = new ItemStack((Block)log, 1, Short.MAX_VALUE);
            ItemStack coalOutput = new ItemStack(Items.field_151044_h, 1, 1);
            GameRegistry.addSmelting((ItemStack)logInput, (ItemStack)coalOutput, (float)0.15f);
        }
        IWoodAccess woodAccess = TreeManager.woodAccess;
        for (EnumETLog enumETLog : EnumETLog.VALUES) {
            ItemStack itemStack = woodAccess.getStack((IWoodType)enumETLog, WoodBlockKind.LOG, false);
            ItemStack planks = enumETLog.getPlank().getStack(false);
            ItemStack fireproofLogs = woodAccess.getStack((IWoodType)enumETLog, WoodBlockKind.LOG, true);
            ItemStack fireproofPlanks = enumETLog.getPlank().getStack(true);
            planks.func_190920_e(4);
            recipeUtil.addShapelessRecipe(enumETLog.getUid() + "_planks", planks.func_77946_l(), itemStack.func_77946_l());
            fireproofPlanks.func_190920_e(4);
            recipeUtil.addShapelessRecipe(enumETLog.getUid() + "_fireproof_planks", fireproofPlanks.func_77946_l(), fireproofLogs);
            if (!ForestryAPI.enabledPlugins.containsAll(Arrays.asList("forestry.factory", "forestry.apiculture"))) continue;
            itemStack.func_190920_e(1);
            fireproofLogs.func_190920_e(1);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofLogs.func_77946_l(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), Mods.Forestry.item("refractory_wax"), Character.valueOf('X'), itemStack.func_77946_l()});
        }
        for (Enum enum_ : ExtraTreePlanks.VALUES) {
            for (boolean fireproof : new boolean[]{false, true}) {
                ItemStack planks = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, fireproof);
                ItemStack slabs = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.SLAB, fireproof);
                ItemStack fences = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.FENCE, fireproof);
                ItemStack fenceGates = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.FENCE_GATE, fireproof);
                ItemStack stairs = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.STAIRS, fireproof);
                String plankUid = ((ExtraTreePlanks)enum_).getWoodType().getUid();
                if (fireproof) {
                    plankUid = plankUid + "_fireproof";
                }
                stairs.func_190920_e(4);
                recipeUtil.addRecipe(plankUid + "_stairs", stairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l());
                slabs.func_190920_e(6);
                recipeUtil.addRecipe(plankUid + "_slabs", slabs.func_77946_l(), "###", Character.valueOf('#'), planks.func_77946_l());
                fences.func_190920_e(3);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_fences", fences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                fenceGates.func_190920_e(1);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_fence_gates", fenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                if (fireproof) continue;
                ItemStack doors = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.DOOR, false);
                doors.func_190920_e(3);
                planks.func_190920_e(1);
                recipeUtil.addRecipe(plankUid + "_doors", doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), planks.func_77946_l());
            }
            if (!ForestryAPI.enabledPlugins.containsAll(Arrays.asList("forestry.factory", "forestry.apiculture"))) continue;
            ItemStack itemStack = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, false);
            ItemStack fireproofPlanks = woodAccess.getStack((IWoodType)((ExtraTreePlanks)enum_).getWoodType(), WoodBlockKind.PLANKS, true);
            itemStack.func_190920_e(1);
            fireproofPlanks.func_190920_e(5);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofPlanks.func_77946_l(), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), Mods.Forestry.item("refractory_wax"), Character.valueOf('X'), itemStack.func_77946_l()});
        }
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeSize());
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeEmbedded());
        ForgeRegistries.RECIPES.register((IForgeRegistryEntry)new MultiFenceRecipeSolid());
        this.addSqueezer((IWoodType)EnumVanillaWoodType.SPRUCE, ExtraTreeLiquid.Resin, 50);
    }

    private void addSqueezer(IWoodType log, ILiquidDefinition liquid, int amount, float pulpChance) {
        FluidStack liquidStack = liquid.get(amount);
        ItemStack logStack = TreeManager.woodAccess.getStack(log, WoodBlockKind.LOG, false);
        RecipeManagers.squeezerManager.addRecipe(10, logStack, liquidStack, Mods.Forestry.stack("wood_pulp"), (int)(100.0f * pulpChance));
    }

    private void addSqueezer(IWoodType log, ILiquidDefinition liquid, int amount) {
        this.addSqueezer(log, liquid, amount, 0.5f);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        for (FruitSprite sprite : FruitSprite.VALUES) {
            sprite.registerSprites();
        }
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        for (IPlankType type : WoodManager.getAllPlankTypes()) {
            type.registerSprites(map);
        }
    }

    @SubscribeEvent
    public static void onRegisterAllele(AlleleRegisterEvent<IAlleleFruit> event) {
        if (event.getAlleleClass() == IAlleleFruit.class) {
            AlleleETFruit.preInit();
        }
    }

    @SubscribeEvent
    public static void speciesRegister(AlleleSpeciesRegisterEvent event) {
        if (event.getRoot() instanceof ITreeRoot) {
            ETTreeDefinition.preInitTrees();
            ExtraTreePlanks.initWoodTypes();
        } else if (event.getRoot() instanceof IButterflyRoot && BinnieCore.isLepidopteryActive()) {
            ButterflySpecies.preInit();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakedEvent(ModelBakeEvent e) {
        List<ModelResourceLocation> models = e.getModelRegistry().func_148742_b().stream().filter(mrl -> mrl.func_110624_b().startsWith("extratrees")).filter(mrl -> mrl.func_110623_a().startsWith("germlings")).collect(Collectors.toList());
        Map<String, ETTreeDefinition> map = Arrays.stream(ETTreeDefinition.values()).collect(Collectors.toMap(o -> o.name().toLowerCase(), o -> o));
        models.forEach(model -> {
            String species = model.func_177518_c().split("=")[1];
            ETTreeDefinition treeSpecies = (ETTreeDefinition)((Object)((Object)map.get(species)));
            int primaryColor = treeSpecies.getLeafColor().getRGB();
            int secondaryColor = treeSpecies.getWoodColor().getRGB();
            IBakedModel bakedModel = (IBakedModel)e.getModelRegistry().func_82594_a(model);
            if (bakedModel == null) {
                return;
            }
            e.getModelRegistry().func_82595_a(model, (Object)new DoublePassBakedModel(bakedModel, primaryColor, secondaryColor));
        });
    }

    static {
        branches = new String[]{"Malus Maleae Amygdaloideae Rosaceae", "Musa   Musaceae Zingiberales Commelinids Angiosperms", "Sorbus Maleae", "Tsuga   Pinaceae", "Fraxinus Oleeae  Oleaceae Lamiales Asterids Angiospems"};
        classifications = new ArrayList<List<String>>();
    }
}

