/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.alveary;

import binnie.extrabees.alveary.AbstractAlvearyLogic;
import binnie.extrabees.alveary.TileEntityExtraBeesAlvearyPart;
import com.google.common.collect.Lists;
import forestry.api.multiblock.IMultiblockComponent;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class AlvearyLogicTransmitter
extends AbstractAlvearyLogic
implements IEnergyStorage {
    private IEnergyStorage internalStorage = new EnergyStorage(2000);

    @Override
    public void updateServer(TileEntityExtraBeesAlvearyPart tile) {
        if (this.internalStorage.getEnergyStored() < 2) {
            return;
        }
        ArrayList esL = Lists.newArrayList();
        for (IMultiblockComponent part : tile.getConnectedComponents()) {
            if (!(part instanceof TileEntity) || !((TileEntity)part).hasCapability(CapabilityEnergy.ENERGY, EnumFacing.UP)) continue;
            esL.add(((TileEntity)part).getCapability(CapabilityEnergy.ENERGY, EnumFacing.UP));
        }
        if (esL.isEmpty()) {
            return;
        }
        int div = esL.size();
        int maxOutput = 500;
        int output = this.internalStorage.getEnergyStored() / div;
        if (output > maxOutput) {
            output = maxOutput;
        }
        if (output < 1) {
            return;
        }
        for (IEnergyStorage handler : esL) {
            int recieved = handler.receiveEnergy(output, false);
            this.internalStorage.extractEnergy(recieved, false);
            if (this.internalStorage.getEnergyStored() >= output) continue;
            return;
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.internalStorage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.internalStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.internalStorage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityEnergy.ENERGY ? this : null);
    }
}

