/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls.tab;

import binnie.core.api.gui.Alignment;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventValueChanged;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class ControlTabBar<T>
extends Control
implements IControlValue<T> {
    private T value;
    private Alignment alignment;

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Alignment alignment, Collection<T> values) {
        this(parent, x, y, width, height, alignment, Iterables.get(values, (int)0));
        super.setValues(values);
    }

    public ControlTabBar(IWidget parent, int x, int y, int width, int height, Alignment alignment, T value) {
        super(parent, x, y, width, height);
        this.value = value;
        this.alignment = alignment;
        this.addEventHandler(EventValueChanged.class, EventHandler.Origin.DIRECT_CHILD, this, event -> this.setValue(event.getValue()));
    }

    private void setValues(Collection<T> values) {
        this.deleteAllChildren();
        float length = values.size();
        int tabDimension = (int)((float)this.getSize().yPos() / length);
        if (this.alignment == Alignment.TOP || this.alignment == Alignment.BOTTOM) {
            tabDimension = (int)((float)this.getSize().xPos() / length);
        }
        int j = 0;
        for (T value : values) {
            if (this.alignment == Alignment.TOP || this.alignment == Alignment.BOTTOM) {
                this.createTab(j * tabDimension, 0, tabDimension, this.getSize().yPos(), value);
            } else {
                this.createTab(0, j * tabDimension, this.getSize().xPos(), tabDimension, value);
            }
            ++j;
        }
    }

    public ControlTab<T> createTab(int x, int y, int w, int h, T value) {
        return new ControlTab<T>(this, x, y, w, h, value);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        boolean change = this.value != value;
        this.value = value;
        if (change) {
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    public Alignment getDirection() {
        return this.alignment;
    }
}

