/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.modules;

import binnie.core.Binnie;
import binnie.core.Mods;
import binnie.core.liquid.DrinkManager;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.core.modules.BinnieModule;
import binnie.core.modules.Module;
import binnie.core.resource.BinnieSprite;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import binnie.extratrees.alcohol.Juice;
import binnie.extratrees.alcohol.Liqueur;
import binnie.extratrees.alcohol.Spirit;
import binnie.extratrees.alcohol.drink.DrinkLiquid;
import binnie.extratrees.alcohol.drink.ItemDrink;
import binnie.extratrees.api.recipes.ExtraTreesRecipeManager;
import binnie.extratrees.api.recipes.IBreweryManager;
import binnie.extratrees.api.recipes.IDistilleryManager;
import binnie.extratrees.api.recipes.IFruitPressManager;
import binnie.extratrees.items.ExtraTreeItems;
import binnie.extratrees.items.Food;
import forestry.api.recipes.ISqueezerRecipe;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

@BinnieModule(moduleID="extratrees.alcohol", moduleContainerID="extratrees", name="Alcohol", unlocalizedDescription="extratrees.module.alcohol")
public class ModuleAlcohol
extends Module {
    @Nullable
    public static ItemDrink drink;
    @Nullable
    public static Block blockDrink;
    @Nullable
    public static BinnieSprite liquid;

    @Override
    public void registerItemsAndBlocks() {
        drink = new ItemDrink();
        ExtraTrees.proxy.registerItem((Item)drink);
    }

    @Override
    public void preInit() {
        liquid = Binnie.RESOURCE.getBlockSprite(ExtraTrees.instance, "liquids/liquid");
        Binnie.LIQUID.createLiquids(Juice.values());
        Binnie.LIQUID.createLiquids(Alcohol.values());
        Binnie.LIQUID.createLiquids(Spirit.values());
        Binnie.LIQUID.createLiquids(Liqueur.values());
        for (Juice juice : Juice.values()) {
            Cocktail.registerIngredient(juice);
        }
        for (Enum enum_ : Alcohol.values()) {
            Cocktail.registerIngredient((ICocktailIngredientProvider)((Object)enum_));
        }
        for (Enum enum_ : Spirit.values()) {
            Cocktail.registerIngredient((ICocktailIngredientProvider)((Object)enum_));
        }
        for (Enum enum_ : Liqueur.values()) {
            Cocktail.registerIngredient((ICocktailIngredientProvider)((Object)enum_));
        }
        DrinkManager.registerDrinkLiquid(new DrinkLiquid("Water", 0xCCCCFF, 0.1f, 0.0f, "water"));
    }

    @Override
    public void init() {
    }

    @Override
    public void postInit() {
        IBreweryManager breweryManager = ExtraTreesRecipeManager.breweryManager;
        IFruitPressManager fruitPressManager = ExtraTreesRecipeManager.fruitPressManager;
        if (fruitPressManager != null) {
            ItemStack wax = Mods.Forestry.stack("beeswax");
            ItemStack waxCast = Mods.Forestry.stackWildcard("wax_cast");
            for (Glassware glassware : Glassware.values()) {
                ItemStack result = drink.getStack(glassware, null, 8);
                Object[] recipe = glassware.getRecipePattern(wax.func_77973_b());
                RecipeManagers.fabricatorManager.addRecipe(waxCast, Fluids.GLASS.getFluid(glassware.getRecipeGlassCost()), result, recipe);
            }
            for (Enum enum_ : Juice.values()) {
                String oreDict = ((Juice)enum_).squeezing;
                ArrayList<ItemStack> ores = new ArrayList<ItemStack>();
                ores.addAll((Collection<ItemStack>)OreDictionary.getOres((String)oreDict));
                for (Food food : Food.values()) {
                    if (!food.getOres().contains(oreDict)) continue;
                    ores.add(food.get(1));
                }
                for (ItemStack stack : ores) {
                    for (ISqueezerRecipe entry : RecipeManagers.squeezerManager.recipes()) {
                        ItemStack input = (ItemStack)entry.getResources().get(0);
                        FluidStack output = entry.getFluidOutput();
                        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)input) && !OreDictionary.itemMatches((ItemStack)input, (ItemStack)stack, (boolean)true)) continue;
                        int amount = output.amount;
                        if (Objects.equals(output.getFluid().getName(), "seedoil")) {
                            amount *= 2;
                        }
                        fruitPressManager.addRecipe(stack, ((Juice)enum_).get(amount));
                    }
                }
            }
        }
        if (breweryManager != null) {
            for (Alcohol alcohol : Alcohol.values()) {
                FluidType type = alcohol.getType();
                for (String fermentLiquid : alcohol.getFermentationLiquid()) {
                    FluidStack fluid = Binnie.LIQUID.getFluidStack(fermentLiquid);
                    if (fluid == null) continue;
                    breweryManager.addRecipe(fluid, type.get());
                }
            }
            breweryManager.addGrainRecipe("seedBarley", Alcohol.Ale.get(), "cropHops");
            breweryManager.addGrainRecipe("seedBarley", Alcohol.Lager.get(), "cropHops", ExtraTreeItems.LAGER_YEAST.get(1));
            breweryManager.addGrainRecipe("seedRoasted", Alcohol.Stout.get(), "cropHops");
            breweryManager.addGrainRecipe("seedCorn", Alcohol.CornBeer.get(), "cropHops");
            breweryManager.addGrainRecipe("seedRye", Alcohol.RyeBeer.get(), "cropHops");
            breweryManager.addGrainRecipe("seedWheat", Alcohol.WheatBeer.get(), "cropHops");
            breweryManager.addGrainRecipe("seedBarley", Alcohol.Barley.get());
            breweryManager.addGrainRecipe("seedCorn", Alcohol.Corn.get());
            breweryManager.addGrainRecipe("seedRye", Alcohol.Rye.get());
            breweryManager.addGrainRecipe("seedWheat", Alcohol.Wheat.get());
        }
        this.addDistillery(Alcohol.Apple, Spirit.AppleBrandy, Spirit.AppleLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pear, Spirit.PearBrandy, Spirit.PearLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Apricot, Spirit.ApricotBrandy, Spirit.ApricotLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Banana, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cherry, Spirit.CherryBrandy, Spirit.CherryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Elderberry, Spirit.ElderberryBrandy, Spirit.ElderberryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Peach, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Plum, Spirit.PlumBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Carrot, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.WhiteWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.RedWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.SparklingWine, Spirit.Brandy, Spirit.Brandy, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Agave, Spirit.Tequila, Spirit.Tequila, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Potato, Spirit.FruitBrandy, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Citrus, Spirit.CitrusBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cranberry, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Pineapple, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Tomato, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Fruit, Spirit.FruitBrandy, Spirit.FruitLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Barley, Spirit.Whiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Wheat, Spirit.WheatWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Rye, Spirit.RyeWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Corn, Spirit.CornWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
    }

    private void addDistillery(IFluidDefinition source, IFluidDefinition singleDistilled, IFluidDefinition doubleDistilled, IFluidDefinition tripleDistilled) {
        int inAmount = 1000;
        int outAmount1 = 800;
        int outAmount2 = 400;
        int outAmount3 = 200;
        IDistilleryManager distilleryManager = ExtraTreesRecipeManager.distilleryManager;
        distilleryManager.addRecipe(source.get(1000), singleDistilled.get(800), 0);
        distilleryManager.addRecipe(source.get(1000), doubleDistilled.get(400), 1);
        distilleryManager.addRecipe(source.get(1000), tripleDistilled.get(200), 2);
        distilleryManager.addRecipe(singleDistilled.get(1000), doubleDistilled.get(400), 0);
        distilleryManager.addRecipe(singleDistilled.get(1000), tripleDistilled.get(200), 1);
        distilleryManager.addRecipe(doubleDistilled.get(1000), tripleDistilled.get(400), 0);
    }
}

