/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.extratrees.api.ICarpentryInterface;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import binnie.extratrees.api.IDesignMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class CarpentryInterface
implements ICarpentryInterface {
    static Map<Integer, IDesignMaterial> woodMap = new LinkedHashMap<Integer, IDesignMaterial>();
    static Map<Integer, IDesign> designMap = new LinkedHashMap<Integer, IDesign>();
    static Map<String, IDesignCategory> designCategories = new HashMap<String, IDesignCategory>();

    @Override
    public boolean registerCarpentryWood(int index, IDesignMaterial wood) {
        return woodMap.put(index, wood) == null;
    }

    @Override
    public int getCarpentryWoodIndex(IDesignMaterial wood) {
        for (Integer integer : woodMap.keySet()) {
            if (!woodMap.get(integer).equals(wood)) continue;
            return integer;
        }
        return -1;
    }

    @Override
    public IDesignMaterial getWoodMaterial(int index) {
        return woodMap.get(index);
    }

    @Override
    public boolean registerDesign(int index, IDesign wood) {
        return designMap.put(index, wood) == null;
    }

    @Override
    public int getDesignIndex(IDesign wood) {
        for (Integer integer : designMap.keySet()) {
            if (!designMap.get(integer).equals(wood)) continue;
            return integer;
        }
        return -1;
    }

    @Override
    public IDesign getDesign(int index) {
        return designMap.get(index);
    }

    @Override
    public boolean registerDesignCategory(IDesignCategory category) {
        return designCategories.put(category.getId(), category) == null;
    }

    @Override
    public Collection<IDesignCategory> getAllDesignCategories() {
        ArrayList<IDesignCategory> categories = new ArrayList<IDesignCategory>();
        for (IDesignCategory category : designCategories.values()) {
            if (category.getDesigns().size() <= 0) continue;
            categories.add(category);
        }
        return categories;
    }

    @Override
    public List<IDesign> getSortedDesigns() {
        ArrayList<IDesign> designs = new ArrayList<IDesign>();
        for (IDesignCategory category : this.getAllDesignCategories()) {
            designs.addAll(category.getDesigns());
        }
        return designs;
    }

    @Override
    @Nullable
    public IDesignMaterial getWoodMaterial(ItemStack stack) {
        for (Map.Entry<Integer, IDesignMaterial> entry : woodMap.entrySet()) {
            for (boolean fireproof : new boolean[]{true, false}) {
                ItemStack key = entry.getValue().getStack(fireproof);
                if (!key.func_77969_a(stack)) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

