/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.alcohol.CocktailLiquid;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Liqueur implements IFluidDefinition,
ICocktailIngredientProvider
{
    Almond("Almond", 14966063, 0.3, 0.2f),
    Orange("Orange", 16353536, 0.4, 0.2f),
    Banana("Banana", 16302592, 0.5, 0.2f),
    Chocolate("Chocolate", 12667680, 0.3, 0.2f),
    Mint("Mint", 2737788, 0.4, 0.2f),
    Hazelnut("Hazelnut", 15570987, 0.3, 0.2f),
    Cinnamon("Cinnamon", 0xE55000, 0.3, 0.2f),
    Coffee("Coffee", 9847577, 0.4, 0.2f),
    Melon("Melon", 11584049, 0.4, 0.2f),
    Anise("Anise", 14344681, 0.3, 0.2f),
    Peach("Peach", 16684384, 0.4, 0.2f),
    Lemon("Lemon", 16311405, 0.4, 0.2f),
    Herbal("Herbal", 16700673, 0.3, 0.2f),
    Cherry("Cherry", 14096641, 0.5, 0.2f),
    Blackcurrant("Blackcurrant", 6962541, 0.5, 0.2f),
    Blackberry("Blackberry", 6837581, 0.5, 0.2f),
    Raspberry("Raspberry", 10158848, 0.5, 0.2f);

    float abv;
    final FluidType type;
    final CocktailLiquid cocktailLiquid;

    private Liqueur(String name, int colour, double transparency, float abv) {
        this(name + " Liqueur", "liqueur." + name.toLowerCase(), colour, transparency, abv);
    }

    private Liqueur(String name, String ident, int color, double transparency, float abv) {
        this.abv = abv;
        this.type = new FluidType(ident, name, color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setShowHandler(type -> type == FluidContainerType.GLASS);
        this.cocktailLiquid = new CocktailLiquid(this.type, abv);
    }

    private void addFlavour(String oreDict) {
    }

    public String toString() {
        return this.type.toString();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public ICocktailIngredient getIngredient() {
        return this.cocktailLiquid;
    }

    static {
        Almond.addFlavour("cropAlmond");
        Orange.addFlavour("cropOrange");
        Banana.addFlavour("cropBanana");
        Chocolate.addFlavour("cropCocoa");
        Mint.addFlavour("cropMint");
        Hazelnut.addFlavour("cropHazelnut");
        Cinnamon.addFlavour("cropCinnamon");
        Coffee.addFlavour("cropCoffee");
        Melon.addFlavour("cropMelon");
        Anise.addFlavour("cropAnise");
        Peach.addFlavour("cropPeach");
        Lemon.addFlavour("cropLemon");
        Herbal.addFlavour("cropHerbal");
        Cherry.addFlavour("cropCherry");
        Blackcurrant.addFlavour("cropBlackcurrant");
        Blackberry.addFlavour("cropBlackberry");
        Raspberry.addFlavour("cropRaspberry");
    }
}

