/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.api.gui.Alignment;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.resource.textures.CraftGUITexture;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IChargedSlots;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlSlotCharge
extends Control {
    private int slot;

    public ControlSlotCharge(IWidget parent, int x, int y, int slot) {
        super(parent, x, y, 4, 18);
        this.slot = slot;
    }

    float getCharge() {
        IChargedSlots slots = Machine.getInterface(IChargedSlots.class, ((Window)Window.get(this)).getInventory());
        return slots == null ? 0.0f : slots.getCharge(this.slot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.PANEL_BLACK, this.getArea());
        CraftGUI.RENDER.texturePercentage(CraftGUI.RENDER.getTexture((Object)CraftGUITexture.SLOT_CHARGE), this.getArea().inset(1), Alignment.BOTTOM, this.getCharge());
    }

    @Override
    public void getHelpTooltip(Tooltip tooltip) {
        tooltip.add("Charge Remaining: " + (int)(this.getCharge() * 100.0f) + "%");
    }
}

