/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlItemDisplay;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.textures.CraftGUITexture;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ControlSlotBase
extends Control
implements ITooltip {
    private ControlItemDisplay itemDisplay;

    public ControlSlotBase(IWidget parent, int x, int y) {
        this(parent, x, y, 18);
    }

    public ControlSlotBase(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
        this.addAttribute(Attribute.MOUSE_OVER);
        this.itemDisplay = new ControlItemDisplay(this, 1, 1, size - 2);
        this.addSelfEventHandler(EventWidget.ChangeSize.class, event -> this.itemDisplay.setSize(this.getSize().sub(new Point(2, 2))));
    }

    protected void setRotating() {
        this.itemDisplay.setRotating();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.SLOT, this.getArea());
        if (this.getTopParent().getMousedOverWidget() == this) {
            Area area = new Area(new Point(1, 1), this.getArea().size().sub(new Point(2, 2)));
            RenderUtil.drawGradientRect(area, -2130706433, -2130706433);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        this.itemDisplay.setItemStack(this.getItemStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getTooltip(Tooltip tooltip, ITooltipFlag tooltipFlag) {
        ItemStack stack = this.getItemStack();
        if (stack.func_190926_b()) {
            return;
        }
        List list = stack.func_82840_a(((Window)this.getTopParent()).getPlayer(), tooltipFlag);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                continue;
            }
            list.set(i, TextFormatting.GRAY + (String)list.get(i));
        }
        tooltip.add(list);
    }

    public abstract ItemStack getItemStack();
}

