/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls;

import binnie.core.api.gui.IPoint;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlText;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.resource.textures.CraftGUITexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlCheckbox
extends Control
implements IControlValue<Boolean> {
    private boolean value;

    public ControlCheckbox(IWidget parent, int x, int y, int w, String text, boolean bool) {
        super(parent, x, y, w > 16 ? w : 16, 16);
        this.value = bool;
        if (w > 16) {
            new ControlText(this, new Area(16, 1, w - 16, 16), text, TextJustification.MIDDLE_CENTER).setColor(0x444444);
        }
        this.addAttribute(Attribute.MOUSE_OVER);
        this.addSelfEventHandler(EventMouse.Down.class, event -> this.toggleValue());
    }

    protected void onValueChanged(boolean value) {
    }

    @Override
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
        this.onValueChanged(value);
        this.callEvent(new EventValueChanged<Boolean>(this, value));
    }

    public void toggleValue() {
        this.setValue(this.getValue() == false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUITexture texture;
        CraftGUITexture craftGUITexture = texture = this.getValue() != false ? CraftGUITexture.CHECKBOX_CHECKED : CraftGUITexture.CHECKBOX;
        if (this.isMouseOver()) {
            texture = this.getValue() != false ? CraftGUITexture.CHECKBOX_CHECKED_HIGHLIGHTED : CraftGUITexture.CHECKBOX_HIGHLIGHTED;
        }
        CraftGUI.RENDER.texture((Object)texture, (IPoint)Point.ZERO);
    }
}

