/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.Binnie;
import binnie.core.ManagerBase;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.genetics.IItemAnalysable;
import binnie.core.genetics.Tolerance;
import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ManagerGenetics
extends ManagerBase {
    private final Map<ISpeciesRoot, IBreedingSystem> BREEDING_SYSTEMS = new LinkedHashMap<ISpeciesRoot, IBreedingSystem>();
    private List<IChromosomeType> invalidChromosomeTypes = new ArrayList<IChromosomeType>();
    private Map<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>> chromosomeArray = new LinkedHashMap<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>>();

    public static boolean isAnalysable(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        return ind != null || stack.func_77973_b() instanceof IItemAnalysable || Binnie.GENETICS.getConversion(stack) != null;
    }

    public static boolean isAnalysed(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        if (ind != null) {
            return ind.isAnalyzed();
        }
        return stack.func_77973_b() instanceof IItemAnalysable && ((IItemAnalysable)stack.func_77973_b()).isAnalysed(stack);
    }

    public static ItemStack analyse(ItemStack stack, World world, GameProfile username) {
        if (!stack.func_190926_b()) {
            ISpeciesRoot root;
            ItemStack conv = Binnie.GENETICS.getConversionStack(stack).func_77946_l();
            if (!conv.func_190926_b()) {
                conv.func_190920_e(stack.func_190916_E());
                stack = conv;
            }
            if ((root = AlleleManager.alleleRegistry.getSpeciesRoot(stack)) != null) {
                IIndividual ind = root.getMember(stack);
                ind.analyze();
                IBreedingTracker breedingTracker = ind.getGenome().getSpeciesRoot().getBreedingTracker(world, username);
                breedingTracker.registerBirth(ind);
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                ind.writeToNBT(nbttagcompound);
                stack.func_77982_d(nbttagcompound);
                return stack;
            }
            if (stack.func_77973_b() instanceof IItemAnalysable) {
                return ((IItemAnalysable)stack.func_77973_b()).analyse(stack);
            }
        }
        return stack;
    }

    @Override
    public void postInit() {
        this.refreshData();
    }

    @Nullable
    public IBreedingSystem getSystem(String string) {
        for (IBreedingSystem system : this.BREEDING_SYSTEMS.values()) {
            if (!system.getIdent().equals(string)) continue;
            return system;
        }
        return null;
    }

    public IBreedingSystem getSystem(ISpeciesRoot root) {
        String rootUID = root.getUID();
        IBreedingSystem system = this.getSystem(rootUID);
        Preconditions.checkState((system != null ? 1 : 0) != 0, (String)"Could not find system for species root %s", (Object)rootUID);
        return system;
    }

    public ISpeciesRoot getSpeciesRoot(IAlleleSpecies species) {
        return species.getRoot();
    }

    public int[] getTolerance(EnumTolerance tol) {
        return Tolerance.values()[tol.ordinal()].getBounds();
    }

    public Collection<IBreedingSystem> getActiveSystems() {
        return this.BREEDING_SYSTEMS.values();
    }

    public void registerBreedingSystem(IBreedingSystem system) {
        this.BREEDING_SYSTEMS.put(system.getSpeciesRoot(), system);
    }

    @Nullable
    public IBreedingSystem getConversionSystem(ItemStack stack) {
        if (!stack.func_190926_b()) {
            for (IBreedingSystem system : this.getActiveSystems()) {
                if (system.getConversion(stack) == null) continue;
                return system;
            }
        }
        return null;
    }

    public ItemStack getConversionStack(ItemStack stack) {
        IBreedingSystem system;
        if (!stack.func_190926_b() && (system = this.getConversionSystem(stack)) != null) {
            return system.getConversionStack(stack);
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public IIndividual getConversion(ItemStack stack) {
        IBreedingSystem system = this.getConversionSystem(stack);
        return system == null ? null : system.getConversion(stack);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        this.refreshData();
    }

    private void refreshData() {
        this.loadAlleles();
        for (IBreedingSystem system : Binnie.GENETICS.getActiveSystems()) {
            system.calculateArrays();
        }
    }

    private void loadAlleles() {
        this.invalidChromosomeTypes.clear();
        for (IBreedingSystem system : this.BREEDING_SYSTEMS.values()) {
            ISpeciesRoot root = system.getSpeciesRoot();
            LinkedHashMap chromosomeMap = new LinkedHashMap();
            for (IChromosomeType chromosome : root.getKaryotype()) {
                TreeSet<IAllele> alleles = new TreeSet<IAllele>(new ComparatorAllele());
                for (IIndividual individual : root.getIndividualTemplates()) {
                    IGenome genome = individual.getGenome();
                    IAllele activeAllele = genome.getActiveAllele(chromosome);
                    IAllele inactiveAllele = genome.getInactiveAllele(chromosome);
                    if (chromosome.getAlleleClass().isInstance(activeAllele)) {
                        alleles.add(activeAllele);
                    }
                    if (!chromosome.getAlleleClass().isInstance(inactiveAllele)) continue;
                    alleles.add(inactiveAllele);
                }
                system.addExtraAlleles(chromosome, alleles);
                if (alleles.size() == 0) {
                    this.invalidChromosomeTypes.add(chromosome);
                    continue;
                }
                ArrayList<IAllele> alleleList = new ArrayList<IAllele>();
                alleleList.addAll(alleles);
                chromosomeMap.put(chromosome, alleleList);
            }
            this.chromosomeArray.put(root, chromosomeMap);
        }
    }

    public Map<IChromosomeType, List<IAllele>> getChromosomeMap(ISpeciesRoot root) {
        return this.chromosomeArray.get(root);
    }

    public Collection<IChromosomeType> getActiveChromosomes(ISpeciesRoot root) {
        return this.getChromosomeMap(root).keySet();
    }

    public boolean isInvalidChromosome(IChromosomeType type) {
        return this.invalidChromosomeTypes.contains(type);
    }

    static class ComparatorAllele
    implements Comparator<IAllele> {
        ComparatorAllele() {
        }

        @Override
        public int compare(IAllele o1, IAllele o2) {
            if (o1 == null || o2 == null) {
                throw new NullPointerException("Allele is null!");
            }
            if (o1 instanceof IAlleleFloat && o2 instanceof IAlleleFloat) {
                return Float.compare(((IAlleleFloat)o1).getValue(), ((IAlleleFloat)o2).getValue());
            }
            if (o1.getClass().equals(IAlleleInteger.class) && o2.getClass().equals(IAlleleInteger.class)) {
                return Integer.compare(((IAlleleInteger)o1).getValue(), ((IAlleleInteger)o2).getValue());
            }
            if (o1.getAlleleName() != null && o2.getAlleleName() != null) {
                return o1.getAlleleName().compareTo(o2.getAlleleName());
            }
            return o1.getUID().compareTo(o2.getUID());
        }
    }
}

