/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.acclimatiser;

import binnie.botany.api.gardening.EnumFertiliserType;
import binnie.botany.api.gardening.IGardeningManager;
import binnie.botany.core.BotanyCore;
import binnie.genetics.machine.acclimatiser.Acclimatiser;
import net.minecraft.item.ItemStack;

public enum ToleranceType {
    Temperature,
    Humidity,
    PH;


    public float getEffect(ItemStack stack) {
        switch (this) {
            case Temperature: {
                return Acclimatiser.getTemperatureEffect(stack);
            }
            case Humidity: {
                return Acclimatiser.getHumidityEffect(stack);
            }
            case PH: {
                IGardeningManager gardening = BotanyCore.getGardening();
                if (gardening.isFertiliser(EnumFertiliserType.ACID, stack)) {
                    return -0.5f * (float)gardening.getFertiliserStrength(stack);
                }
                if (!gardening.isFertiliser(EnumFertiliserType.ALKALINE, stack)) break;
                return 0.5f * (float)gardening.getFertiliserStrength(stack);
            }
        }
        return 0.0f;
    }

    public boolean hasEffect(ItemStack stack) {
        return this.getEffect(stack) != 0.0f;
    }
}

