/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.gui.analyst;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextCentered;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.scroll.ControlScrollBar;
import binnie.core.gui.controls.scroll.ControlScrollableContent;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.gui.window.Panel;
import binnie.core.util.I18N;
import binnie.genetics.gui.analyst.ControlAnalystPage;
import binnie.genetics.gui.analyst.ControlIndividualDisplay;
import binnie.genetics.gui.analyst.WindowAnalyst;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AnalystPageDatabase
extends ControlAnalystPage {
    private final ControlScrollableContent scroll;
    boolean isMaster;

    public AnalystPageDatabase(IWidget parent, Area area, final IBreedingSystem system, boolean isMaster) {
        super(parent, area);
        this.isMaster = isMaster;
        this.setColor(AnalystPageDatabase.getColor(system));
        int y = 4;
        new ControlTextCentered((IWidget)this, y, TextFormatting.UNDERLINE + this.getTitle()).setColor(this.getColor());
        new ControlTextEdit(this, 20, y += 16, this.getWidth() - 40, 16){

            @Override
            public void onTextEdit(String value) {
                ArrayList<IAlleleSpecies> options = new ArrayList<IAlleleSpecies>();
                AnalystPageDatabase.this.getSpecies(system);
                for (IAlleleSpecies species : AnalystPageDatabase.this.getSpecies(system)) {
                    if (value != null && !Objects.equals(value, "") && !species.getAlleleName().toLowerCase().contains(value.toLowerCase())) continue;
                    options.add(species);
                }
                AnalystPageDatabase.this.scroll.deleteAllChildren();
                AnalystPageDatabase.this.scroll.setScrollableContent(AnalystPageDatabase.this.getItemScrollList(system, options));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderBackground(int guiWidth, int guiHeight) {
                RenderUtil.setColour(0x555555);
                CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_SOLID, this.getArea().inset(1));
                RenderUtil.setColour(AnalystPageDatabase.this.getColor());
                CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_OUTLINE, this.getArea());
                this.renderTextField();
            }
        };
        new Panel(this, 3, (y += 22) - 1, this.getWidth() - 6, this.getHeight() - y - 8 + 2, MinecraftGUI.PanelType.TAB_OUTLINE).setColor(this.getColor());
        boolean textView = false;
        final Collection<IAlleleSpecies> options = this.getSpecies(system);
        for (IAlleleSpecies species : options) {
            String height = system.getAlleleName((IChromosomeType)EnumTreeChromosome.HEIGHT, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.HEIGHT));
            String fertility = system.getAlleleName((IChromosomeType)EnumTreeChromosome.FERTILITY, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.FERTILITY));
            String yield = system.getAlleleName((IChromosomeType)EnumTreeChromosome.YIELD, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.YIELD));
            String sappiness = system.getAlleleName((IChromosomeType)EnumTreeChromosome.SAPPINESS, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.SAPPINESS));
            String string = system.getAlleleName((IChromosomeType)EnumTreeChromosome.MATURATION, system.getIndividual(species.getUID()).getGenome().getActiveAllele((IChromosomeType)EnumTreeChromosome.MATURATION));
        }
        if (textView) {
            this.scroll = new ControlListBox<IAlleleSpecies>((IWidget)this, 4, y, this.getWidth() - 8, this.getHeight() - y - 8 - 20, 0){

                @Override
                public void initialise() {
                    super.initialise();
                    this.setOptions(options);
                }

                @Override
                public IWidget createOption(final IAlleleSpecies v, int y) {
                    return new Control((IWidget)this.getContent(), 0, y, this.getWidth(), 12){
                        IAlleleSpecies value;
                        {
                            super(x0, x1, x2, x3, x4);
                            this.value = v;
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public void onRenderBackground(int guiWidth, int guiHeight) {
                            RenderUtil.drawText(this.getArea(), TextJustification.MIDDLE_CENTER, this.value.getAlleleName(), 0xFFFFFF);
                        }
                    };
                }
            };
        } else {
            this.scroll = new ControlScrollableContent(this, 4, y, this.getWidth() - 8, this.getHeight() - y - 8, 0);
            this.scroll.setScrollableContent(this.getItemScrollList(system, options));
        }
        new ControlScrollBar(this, this.scroll.getXPos() + this.scroll.getWidth() - 6, this.scroll.getYPos() + 3, 3, this.scroll.getHeight() - 6, this.scroll){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void onRenderBackground(int guiWidth, int guiHeight) {
                if (!this.isEnabled()) {
                    return;
                }
                RenderUtil.drawGradientRect(this.getArea(), 0x44000000 + AnalystPageDatabase.this.getColor(), 0x44000000 + AnalystPageDatabase.this.getColor());
                RenderUtil.drawSolidRect(this.getRenderArea(), AnalystPageDatabase.this.getColor());
            }
        };
    }

    private static int getColor(IBreedingSystem system) {
        int cOfSystem = system.getColour();
        int cr = (0xFF0000 & cOfSystem) >> 16;
        int cg = (0xFF00 & cOfSystem) >> 8;
        int cb = 0xFF & cOfSystem;
        float brightness = 0.1f * (float)cb / 255.0f + 0.35f * (float)cr / 255.0f + 0.55f * (float)cg / 255.0f;
        if ((brightness = 0.3f / brightness) > 1.0f) {
            brightness = 1.0f;
        }
        return (int)((float)cr * brightness) * 65536 + (int)((float)cg * brightness) * 256 + (int)((float)cb * brightness);
    }

    private IWidget getItemScrollList(final IBreedingSystem system, final Collection<IAlleleSpecies> options) {
        return new Control(this.scroll, 0, 0, this.scroll.getWidth(), this.scroll.getHeight()){

            @Override
            public void initialise() {
                int maxBiomePerLine = (this.getWidth() - 4 + 2) / 18;
                int biomeListX = -6 + (this.getWidth() - (maxBiomePerLine * 18 - 2)) / 2;
                int dx = 0;
                int dy = 0;
                for (final IAlleleSpecies species : options) {
                    final IIndividual ind = system.getSpeciesRoot().templateAsIndividual(system.getSpeciesRoot().getTemplate(species));
                    new ControlIndividualDisplay(this, biomeListX + dx, 2 + dy, ind){

                        @Override
                        public void initialise() {
                            this.addSelfEventHandler(EventMouse.Down.class, event -> {
                                WindowAnalyst window = (WindowAnalyst)AnalystPageDatabase.this.getTopParent();
                                window.setIndividual(ind);
                            });
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public void onRenderBackground(int guiWidth, int guiHeight) {
                            WindowAnalyst window = (WindowAnalyst)AnalystPageDatabase.this.getTopParent();
                            if (window.getIndividual() != null && window.getIndividual().getGenome().getPrimary() == species) {
                                RenderUtil.setColour(0xEEEEEE);
                                CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_SOLID, this.getArea().outset(1));
                                RenderUtil.setColour(AnalystPageDatabase.this.getColor());
                                CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_OUTLINE, this.getArea().outset(1));
                            } else if (this.calculateIsMouseOver()) {
                                RenderUtil.setColour(0xEEEEEE);
                                CraftGUI.RENDER.texture((Object)CraftGUITexture.TAB_SOLID, this.getArea().outset(1));
                            }
                            super.onRenderBackground(guiWidth, guiHeight);
                        }
                    };
                    if ((dx += 18) < 18 * maxBiomePerLine) continue;
                    dx = 0;
                    dy += 18;
                }
                this.setSize(new Point(this.getWidth(), 4 + dy + 18));
            }
        };
    }

    @Override
    public String getTitle() {
        return I18N.localise("genetics.gui.analyst.registry.title");
    }

    private Collection<IAlleleSpecies> getSpecies(IBreedingSystem system) {
        ArrayList<IAlleleSpecies> species = new ArrayList<IAlleleSpecies>();
        species.addAll(this.isMaster ? system.getAllSpecies() : system.getDiscoveredSpecies(this.getWindow().getWorld(), this.getWindow().getPlayer().func_146103_bH()));
        return species;
    }
}

