/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gui.database;

import binnie.core.AbstractMod;
import binnie.core.api.gui.IArea;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.listbox.ControlList;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.database.ControlItemStackOption;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.PageBranchOverview;
import binnie.core.gui.database.PageBranchSpecies;
import binnie.core.gui.database.PageBreeder;
import binnie.core.gui.database.PageSpeciesClassification;
import binnie.core.gui.database.PageSpeciesMutations;
import binnie.core.gui.database.PageSpeciesOverview;
import binnie.core.gui.database.PageSpeciesResultant;
import binnie.core.gui.database.WindowAbstractDatabase;
import binnie.core.gui.minecraft.Window;
import binnie.core.util.I18N;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.IDesignMaterial;
import binnie.extratrees.genetics.TreeBreedingSystem;
import binnie.extratrees.gui.database.PageFruit;
import binnie.extratrees.gui.database.PagePlanksOverview;
import binnie.extratrees.gui.database.PagePlanksTrees;
import binnie.extratrees.gui.database.PageSpeciesTreeGenome;
import binnie.extratrees.gui.database.PageWood;
import binnie.extratrees.modules.ModuleWood;
import binnie.extratrees.wood.WoodManager;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WindowArboristDatabase
extends WindowAbstractDatabase {
    ControlListBox<ItemStack> selectionBoxFruit;
    ControlListBox<ItemStack> selectionBoxWood;
    ControlListBox<ItemStack> selectionBoxPlanks;

    public WindowArboristDatabase(EntityPlayer player, Side side, boolean nei) {
        super(player, side, nei, ModuleWood.treeBreedingSystem, 120);
    }

    public static Window create(EntityPlayer player, Side side, boolean nei) {
        return new WindowArboristDatabase(player, side, nei);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
        new PageSpeciesOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.overview"));
        new PageSpeciesTreeGenome((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.genome"));
        new PageSpeciesClassification((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.classification"));
        new PageSpeciesResultant((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.resultant"));
        new PageSpeciesMutations((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.SPECIES), new DatabaseTab(ExtraTrees.instance, "species.further"));
        new PageBranchOverview((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.overview"));
        new PageBranchSpecies((IWidget)this.getInfoPages(WindowAbstractDatabase.Mode.BRANCHES), new DatabaseTab(ExtraTrees.instance, "branches.species"));
        new PageBreeder(this.getInfoPages(WindowAbstractDatabase.Mode.BREEDER), this.getUsername(), new DatabaseTab(ExtraTrees.instance, "breeder"));
        this.createMode(TreeMode.FRUIT, new WindowAbstractDatabase.ModeWidgets(TreeMode.FRUIT, this){

            @Override
            public void createListBox(IArea area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                TreeBreedingSystem breedingSystem = (TreeBreedingSystem)WindowArboristDatabase.this.getBreedingSystem();
                controlListBox.setOptions(breedingSystem.allFruits);
                this.listBox = controlListBox;
            }
        });
        this.createMode(TreeMode.WOOD, new WindowAbstractDatabase.ModeWidgets(TreeMode.WOOD, this){

            @Override
            public void createListBox(IArea area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                TreeBreedingSystem breedingSystem = (TreeBreedingSystem)WindowArboristDatabase.this.getBreedingSystem();
                controlListBox.setOptions(breedingSystem.allWoods);
                this.listBox = controlListBox;
            }
        });
        this.createMode(TreeMode.PLANKS, new WindowAbstractDatabase.ModeWidgets(TreeMode.PLANKS, this){

            @Override
            public void createListBox(IArea area) {
                ControlListBox<ItemStack> controlListBox = new ControlListBox<ItemStack>((IWidget)this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public IWidget createOption(ItemStack value, int y) {
                        return new ControlItemStackOption((ControlList)this.getContent(), value, y);
                    }
                };
                controlListBox.setOptions(WoodManager.getAllPlankTypes().stream().map(IDesignMaterial::getStack).collect(Collectors.toList()));
                this.listBox = controlListBox;
            }
        });
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.natural"), true);
        new PageFruit(this.getInfoPages(TreeMode.FRUIT), new DatabaseTab(ExtraTrees.instance, "fruit.potential"), false);
        new PageWood((IWidget)this.getInfoPages(TreeMode.WOOD), new DatabaseTab(ExtraTrees.instance, "wood.natural"));
        new PagePlanksOverview((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.overview"));
        new PagePlanksTrees((IWidget)this.getInfoPages(TreeMode.PLANKS), new DatabaseTab(ExtraTrees.instance, "planks.natural"));
    }

    @Override
    protected AbstractMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getBackgroundTextureName() {
        return "TreeDatabase";
    }

    static enum TreeMode implements IDatabaseMode
    {
        FRUIT,
        WOOD,
        PLANKS;


        @Override
        public String getName() {
            return I18N.localise("extratrees.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

