/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.FluidContainerType;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.IFluidDefinition;
import binnie.extratrees.alcohol.CocktailLiquid;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ICocktailIngredientProvider;
import binnie.extratrees.alcohol.Juice;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public enum Alcohol implements IFluidDefinition,
ICocktailIngredientProvider
{
    Apple("cider.apple", 16432700, 0.3, 0.05f){

        @Override
        protected void init() {
            this.addFementation(Juice.Apple);
        }
    }
    ,
    Apricot("wine.apricot", 15781686, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Apricot);
        }
    }
    ,
    Banana("wine.banana", 14993485, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Banana);
        }
    }
    ,
    Cherry("wine.cherry", 11207702, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Cherry);
        }
    }
    ,
    Elderberry("wine.elderberry", 9764865, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Elderberry);
        }
    }
    ,
    Peach("cider.peach", 15361563, 0.3, 0.05f){

        @Override
        protected void init() {
            this.addFementation(Juice.Peach);
        }
    }
    ,
    Pear("ciderpear", 15061095, 0.3, 0.05f){

        @Override
        protected void init() {
            this.addFementation(Juice.Pear);
        }
    }
    ,
    Plum("wine.plum", 12063752, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Plum);
        }
    }
    ,
    Carrot("wine.carrot", 16219394, 0.3, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Carrot);
        }
    }
    ,
    WhiteWine("wine.white", 15587989, 0.1, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.WhiteGrape);
        }
    }
    ,
    RedWine("wine.red", 7670539, 0.2, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.RedGrape);
        }
    }
    ,
    SparklingWine("wine.sparkling", 16709566, 0.1, 0.1f),
    Agave("wine.agave", 13938276, 0.2, 0.1f),
    Potato("fermented.potatoes", 12028240, 0.8, 0.1f){

        @Override
        protected void init() {
            this.addFementation("cropPotato");
        }
    }
    ,
    Citrus("wine.citrus", 0xFFFF00, 0.2, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Lemon);
            this.addFementation(Juice.Lime);
            this.addFementation(Juice.Orange);
            this.addFementation(Juice.Grapefruit);
        }
    }
    ,
    Cranberry("wine.cranberry", 11599874, 0.2, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Cranberry);
        }
    }
    ,
    Pineapple("wine.pineapple", 14724150, 0.2, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Pineapple);
        }
    }
    ,
    Tomato("wine.tomato", 12458521, 0.2, 0.1f){

        @Override
        protected void init() {
            this.addFementation(Juice.Tomato);
        }
    }
    ,
    Fruit("juice", 16432700, 0.2, 0.1f),
    Ale("beer.ale", 12991009, 0.7, 0.05f),
    Lager("beer.lager", 15301637, 0.7, 0.05f),
    WheatBeer("beer.wheat", 14380552, 0.7, 0.05f),
    RyeBeer("beer.rye", 10836007, 0.7, 0.05f),
    CornBeer("beer.corn", 13411364, 0.7, 0.05f),
    Stout("beer.stout", 5843201, 0.8, 0.05f),
    Barley("mash.grain", 12991009, 0.9, 0.05f),
    Wheat("mash.wheat", 12991009, 0.9, 0.05f),
    Rye("mash.rye", 10836007, 0.9, 0.05f),
    Corn("mash.corn", 13411364, 0.9, 0.05f);

    final List<String> fermentationLiquid = new ArrayList<String>();
    final FluidType type;
    String fermentationSolid = "";
    CocktailLiquid cocktailLiquid;

    private Alcohol(String ident, int color, double transparency, float abv) {
        this.init();
        this.type = new FluidType(ident, "extratrees.fluid.alcohol." + this.name().toLowerCase(), color).setTransparency(transparency).setTextures(new ResourceLocation("extratrees", "blocks/liquids/liquid")).setPlaceHandler(type -> type == FluidContainerType.GLASS);
        this.cocktailLiquid = new CocktailLiquid(this.type, abv);
    }

    protected void init() {
    }

    @Override
    public FluidType getType() {
        return this.type;
    }

    @Override
    public ICocktailIngredient getIngredient() {
        return this.cocktailLiquid;
    }

    public List<String> getFermentationLiquid() {
        return this.fermentationLiquid;
    }

    protected void addFementation(Juice juice) {
        this.fermentationLiquid.add(juice.type.getDisplayName());
    }

    protected void addFementation(String oreDict) {
        this.fermentationSolid = oreDict;
    }

    public String toString() {
        return this.type.getDisplayName();
    }

    @Override
    public FluidStack get(int amount) {
        return this.type.get(amount);
    }
}

