/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.ITexture;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.Texture;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.gui.resource.minecraft.CraftGUITextureSheet;
import binnie.core.gui.resource.minecraft.StandardTexture;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

class ControlBreedingProgress
extends Control {
    private static Texture Progress = new StandardTexture(80, 22, 4, 4, CraftGUITextureSheet.CONTROLS);
    private float percentage;
    private int colour;

    public ControlBreedingProgress(IWidget parent, int x, int y, int width, int height, IBreedingSystem system, float percentage) {
        super(parent, x, y, width, height);
        this.percentage = percentage;
        this.colour = system.getColour();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.PANEL_BLACK, this.getArea());
        IArea area = this.getArea().inset(1);
        area.setSize(new Point(Math.round((float)area.size().xPos() * this.percentage), area.size().yPos()));
        RenderUtil.setColour(this.colour);
        CraftGUI.RENDER.texture((ITexture)Progress, area);
    }
}

