/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.isolator;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IRender;
import java.util.Random;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IsolaterFX
extends MachineComponent
implements IRender.RandomDisplayTick,
IRender.DisplayTick {
    public IsolaterFX(IMachine machine) {
        super(machine);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRandomDisplayTick(World world, BlockPos pos, Random rand) {
        if (!this.getUtil().getProcess().isInProgress()) {
            return;
        }
        IsolaterParticleRandomTick particle = new IsolaterParticleRandomTick(world, pos, rand);
        BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a((Particle)particle);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDisplayTick(World world, BlockPos pos, Random rand) {
        int tick = (int)(world.func_82737_E() % 6L);
        if ((tick == 0 || tick == 5) && this.getUtil().getProcess().isInProgress()) {
            IsolaterParticle particle = new IsolaterParticle(world, pos);
            BinnieCore.getBinnieProxy().getMinecraftInstance().field_71452_i.func_78873_a((Particle)particle);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class IsolaterParticle
    extends Particle {
        double axisX;
        double axisZ;
        double angle;

        public IsolaterParticle(World world, BlockPos pos) {
            super(world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            this.axisX = this.field_187126_f;
            this.axisZ = this.field_187128_h;
            this.angle = 0.7 + (double)((int)(this.field_187122_b.func_82737_E() % 2L)) * 3.1415;
            this.axisX = 0.0;
            this.axisZ = 0.0;
            this.angle = 0.0;
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.012;
            this.field_70547_e = 100;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.func_70538_b(0.8f, 0.0f, 1.0f);
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.angle += 0.06;
            this.func_187109_b(this.axisX + 0.26 * Math.sin(this.angle), this.field_187127_g, this.axisZ + 0.26 * Math.cos(this.angle));
            this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
        }

        public int func_70537_b() {
            return 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class IsolaterParticleRandomTick
    extends Particle {
        double axisX = 0.0;
        double axisZ = 0.0;
        double angle = 0.0;

        public IsolaterParticleRandomTick(World world, BlockPos pos, Random rand) {
            super(world, (double)pos.func_177958_n() + 0.4 + 0.2 * rand.nextDouble(), (double)pos.func_177956_o() + 1.6, (double)pos.func_177952_p() + 0.4 + rand.nextDouble() * 0.2, 0.0, 0.0, 0.0);
            this.field_187129_i = 0.0;
            this.field_187131_k = 0.0;
            this.field_187130_j = -0.012;
            this.field_70547_e = 100;
            this.field_70545_g = 0.0f;
            this.field_190017_n = true;
            this.func_70538_b(0.8f, 0.4f, 0.0f);
        }

        public void func_189213_a() {
            super.func_189213_a();
            this.angle += 0.06;
            this.func_82338_g((float)Math.sin(3.14 * (double)this.field_70546_d / (double)this.field_70547_e));
        }

        public int func_70537_b() {
            return 0;
        }
    }
}

