/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.fruitpress;

import binnie.core.machines.Machine;
import binnie.core.machines.errors.CoreErrorCode;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateDefinition;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.IProcess;
import binnie.extratrees.machines.ExtraTreesErrorCode;
import binnie.extratrees.machines.fruitpress.recipes.FruitPressRecipeManager;
import net.minecraftforge.fluids.FluidStack;

public class FruitPressLogic
extends ComponentProcessSetCost
implements IProcess {
    public static final int PROCESS_ENERGY = 1000;
    public static final int PROCESS_LENGTH = 50;
    private int lastProgress = 0;

    public FruitPressLogic(Machine machine) {
        super(machine, 1000, 50);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(1)) {
            return new ErrorState((IErrorStateDefinition)ExtraTreesErrorCode.FRUITPRESS_NO_FRUIT, 1);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (!this.getUtil().spaceInTank(0, 5)) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.NO_SPACE_TANK, 0);
        }
        FluidStack fluidOutputTank = this.getUtil().getFluid(0);
        FluidStack recipeOutput = FruitPressRecipeManager.getOutput(this.getUtil().getStack(1));
        if (fluidOutputTank != null && !fluidOutputTank.isFluidEqual(recipeOutput)) {
            return new ErrorState((IErrorStateDefinition)CoreErrorCode.TANK_DIFFRENT_FLUID, 0);
        }
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        this.getUtil().decreaseStack(1, 1);
    }

    @Override
    protected void onTickTask() {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        FluidStack output = FruitPressRecipeManager.getOutput(this.getUtil().getStack(1));
        if (output == null) {
            return;
        }
        int newProgress = (int)this.getProgress();
        while (this.lastProgress + 4 <= newProgress) {
            int change = newProgress - this.lastProgress;
            int amount = output.amount * change / 100;
            FluidStack tank = new FluidStack(output, amount);
            this.getUtil().fillTank(0, tank);
            this.lastProgress += 4;
        }
        if (this.lastProgress > newProgress) {
            this.lastProgress = 0;
        }
    }

    @Override
    protected void onStartTask() {
        super.onStartTask();
        this.lastProgress = 0;
    }
}

