/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IArea;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Area;
import binnie.core.gui.geometry.Border;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.geometry.TextJustification;
import binnie.core.gui.renderer.RenderUtil;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlSlide
extends Control {
    private IArea expanded;
    private IArea shrunk;
    private boolean slideActive = true;
    private Alignment anchor;
    private String label = null;

    public ControlSlide(IWidget parent, int x, int y, int w, int h, Alignment anchor2) {
        super(parent, x, y, w, h);
        this.addAttribute(Attribute.MOUSE_OVER);
        this.addAttribute(Attribute.BLOCK_TOOLTIP);
        this.expanded = new Area(this.getPosition(), this.getSize());
        this.anchor = anchor2.opposite();
        int border = this.anchor.x() != 0 ? this.expanded.width() - 6 : this.expanded.height() - 6;
        this.shrunk = this.expanded.inset(new Border(this.anchor, border));
        this.slideActive = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        super.onRenderBackground(guiWidth, guiHeight);
        if (this.label != null) {
            int lw = RenderUtil.getTextWidth(this.label) + 16;
            int lh = RenderUtil.getTextHeight() + 16;
            boolean hor = this.anchor.x() != 0;
            IArea ar = this.isSlideActive() ? this.expanded : this.shrunk;
            IArea tabArea = new Area(hor ? -lh / 2 : -lw / 2, hor ? -lw / 2 : -lh / 2, hor ? lh : lw, hor ? lw : lh);
            Point shift = new Point(ar.width() * (1 - this.anchor.x()) / 2, ar.height() * (1 - this.anchor.y()) / 2);
            tabArea = tabArea.shift(shift.xPos() - (-3 + lh / 2) * this.anchor.x(), shift.yPos() - (-3 + lh / 2) * this.anchor.y());
            ITexture texture = CraftGUI.RENDER.getTexture((Object)(this.isSlideActive() ? CraftGUITexture.TAB : CraftGUITexture.TAB_DISABLED)).crop(this.anchor.opposite(), 8);
            CraftGUI.RENDER.texture(texture, tabArea);
            texture = CraftGUI.RENDER.getTexture((Object)CraftGUITexture.TAB_OUTLINE).crop(this.anchor.opposite(), 8);
            CraftGUI.RENDER.texture(texture, tabArea.inset(2));
            Area labelArea = new Area(-lw / 2, 0, lw, lh);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(shift.xPos() + this.anchor.x() * 2), (float)(shift.yPos() + this.anchor.y() * 2), (float)0.0f);
            if (this.anchor.x() != 0) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)this.anchor.x());
            }
            if (this.anchor.y() > 0) {
                GlStateManager.func_179109_b((float)0.0f, (float)(-lh), (float)0.0f);
            }
            RenderUtil.drawText(labelArea, TextJustification.MIDDLE_CENTER, this.label, 0xFFFFFF);
            GlStateManager.func_179121_F();
        }
        CraftGUI.RENDER.texture((Object)CraftGUITexture.WINDOW, this.getArea());
        CraftGUITexture slideTexture = this.anchor == Alignment.BOTTOM ? CraftGUITexture.SLIDE_DOWN : (this.anchor == Alignment.TOP ? CraftGUITexture.SLIDE_UP : (this.anchor == Alignment.LEFT ? CraftGUITexture.SLIDE_LEFT : CraftGUITexture.SLIDE_RIGHT));
        CraftGUI.RENDER.texture((Object)slideTexture, (IPoint)new Point((this.anchor.x() + 1) * this.getWidth() / 2 - 8, (this.anchor.y() + 1) * this.getHeight() / 2 - 8));
    }

    public boolean isSlideActive() {
        return this.slideActive;
    }

    @Override
    public void onUpdateClient() {
        boolean mouseOver = this.isMouseOverWidget(this.getRelativeMousePosition());
        if (mouseOver != this.slideActive) {
            this.setSlide(mouseOver);
        }
    }

    @Override
    public boolean isMouseOverWidget(IPoint relativeMouse) {
        return this.getArea().outset(this.isSlideActive() ? 16 : 8).outset(new Border(this.anchor.opposite(), 16)).contains(relativeMouse);
    }

    @Override
    public boolean isChildVisible(IWidget child) {
        return this.slideActive;
    }

    public void setSlide(boolean b) {
        this.slideActive = b;
        IArea area = this.isSlideActive() ? this.expanded : this.shrunk;
        this.setSize(area.size());
        this.setPosition(area.pos());
    }

    public void setLabel(String l) {
        this.label = l;
    }
}

