/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.database;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.gui.Alignment;
import binnie.core.api.gui.IArea;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.ControlTextEdit;
import binnie.core.gui.controls.listbox.ControlListBox;
import binnie.core.gui.controls.listbox.ControlTextOption;
import binnie.core.gui.controls.page.ControlPage;
import binnie.core.gui.controls.page.ControlPages;
import binnie.core.gui.controls.tab.ControlTab;
import binnie.core.gui.controls.tab.ControlTabBar;
import binnie.core.gui.database.ControlBranchBox;
import binnie.core.gui.database.ControlSpeciesBox;
import binnie.core.gui.database.DatabaseTab;
import binnie.core.gui.database.IDatabaseMode;
import binnie.core.gui.database.PageAbstract;
import binnie.core.gui.events.EventHandler;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventValueChanged;
import binnie.core.gui.geometry.CraftGUIUtil;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.MinecraftGUI;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlHelp;
import binnie.core.gui.window.Panel;
import binnie.core.util.I18N;
import com.mojang.authlib.GameProfile;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IClassification;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WindowAbstractDatabase
extends Window {
    boolean isNEI;
    private int selectionBoxWidth = 95;
    private Map<IDatabaseMode, ModeWidgets> modes = new HashMap<IDatabaseMode, ModeWidgets>();
    private IBreedingSystem system;
    @Nullable
    private Panel panelInformation = null;
    @Nullable
    private Panel panelSearch = null;
    @Nullable
    private ControlPages<IDatabaseMode> modePages = null;
    @Nullable
    private IAlleleSpecies gotoSpecies = null;

    public WindowAbstractDatabase(EntityPlayer player, Side side, boolean nei, IBreedingSystem system, int wid) {
        super(100, 192, player, null, side);
        this.isNEI = nei;
        this.system = system;
        this.selectionBoxWidth = wid;
    }

    public void changeMode(IDatabaseMode mode) {
        this.modePages.setValue(mode);
    }

    public ControlPages<DatabaseTab> getInfoPages(IDatabaseMode mode) {
        return this.modes.get(mode).infoPages;
    }

    public boolean isNEI() {
        return this.isNEI;
    }

    public IBreedingSystem getBreedingSystem() {
        return this.system;
    }

    protected ModeWidgets createMode(IDatabaseMode mode, ModeWidgets widgets) {
        this.modes.put(mode, widgets);
        return widgets;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initialiseClient() {
        this.setSize(new Point(176 + this.selectionBoxWidth + 22 + 8, 208));
        this.addEventHandler(EventValueChanged.class, event -> {
            ControlPage parent;
            if (event.getOrigin().getParent() instanceof ControlPage && !(event.getValue() instanceof DatabaseTab) && (parent = (ControlPage)event.getOrigin().getParent()).getValue() instanceof IDatabaseMode) {
                for (IWidget child : parent.getChildren()) {
                    if (!(child instanceof ControlPages)) continue;
                    if (event.getValue() == null) {
                        child.hide();
                        continue;
                    }
                    child.show();
                    for (IWidget widget : child.getChildren()) {
                        if (!(widget instanceof PageAbstract)) continue;
                        ((PageAbstract)widget).onValueChanged(event.getValue());
                    }
                }
            }
        });
        this.addEventHandler(EventTextEdit.class, EventHandler.Origin.DIRECT_CHILD, this, event -> {
            for (ModeWidgets widgets : this.modes.values()) {
                widgets.listBox.setValidator(object -> {
                    if (Objects.equals(event.getValue(), "")) {
                        return true;
                    }
                    return ((ControlTextOption)object).getText().toLowerCase().contains(((String)event.getValue()).toLowerCase());
                });
            }
        });
        new ControlHelp(this, 4, 4);
        this.panelInformation = new Panel(this, 24, 24, 144, 176, MinecraftGUI.PanelType.BLACK);
        this.panelInformation.setColor(860416);
        this.panelSearch = new Panel(this, 176, 24, this.selectionBoxWidth, 160, MinecraftGUI.PanelType.BLACK);
        this.panelSearch.setColor(860416);
        this.modePages = new ControlPages(this, 0, 0, this.getSize().xPos(), this.getSize().yPos());
        new ControlTextEdit(this, 176, 184, this.selectionBoxWidth, 16);
        this.createMode(Mode.SPECIES, new SpeciesModeWidgets());
        this.createMode(Mode.BRANCHES, new BranchesModeWidgets());
        this.createMode(Mode.BREEDER, new BreederModeWidgets());
        this.addTabs();
        ControlTabBar<IDatabaseMode> tab = new ControlTabBar<IDatabaseMode>((IWidget)this, 176 + this.selectionBoxWidth, 24, 22, 176, Alignment.RIGHT, this.modePages.getValues()){

            @Override
            public ControlTab<IDatabaseMode> createTab(int x, int y, int w, int h, IDatabaseMode value) {
                return new ControlTab<IDatabaseMode>((ControlTabBar)this, x, y, w, h, value){

                    @Override
                    public String getName() {
                        return ((IDatabaseMode)this.value).getName();
                    }
                };
            }
        };
        CraftGUIUtil.linkWidgets(tab, this.modePages);
        this.changeMode(Mode.SPECIES);
        for (IDatabaseMode mode : this.modes.keySet()) {
            this.modes.get(mode).infoTabs = new ControlTabBar((IWidget)this.modes.get((Object)mode).modePage, 8, 24, 16, 176, Alignment.LEFT, this.modes.get(mode).infoPages.getValues());
            CraftGUIUtil.linkWidgets(this.modes.get(mode).infoTabs, this.modes.get(mode).infoPages);
        }
    }

    @Override
    public void initialiseServer() {
        IBreedingTracker tracker = this.system.getSpeciesRoot().getBreedingTracker(this.getWorld(), this.getUsername());
        if (tracker != null) {
            tracker.synchToPlayer(this.getPlayer());
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void addTabs() {
    }

    public void gotoSpecies(IAlleleSpecies value) {
        if (value != null) {
            this.modePages.setValue(Mode.SPECIES);
            this.changeMode(Mode.SPECIES);
            this.modes.get((Object)this.modePages.getValue()).listBox.setValue(value);
        }
    }

    public void gotoSpeciesDelayed(IAlleleSpecies species) {
        this.gotoSpecies = species;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onUpdateClient() {
        super.onUpdateClient();
        if (this.gotoSpecies != null) {
            ((WindowAbstractDatabase)this.getTopParent()).gotoSpecies(this.gotoSpecies);
            this.gotoSpecies = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class BreederModeWidgets
    extends ModeWidgets {
        public BreederModeWidgets() {
            super(Mode.BREEDER, WindowAbstractDatabase.this);
        }

        @Override
        public void createListBox(IArea area) {
            this.listBox = new ControlListBox(this.modePage, area.xPos(), area.yPos(), area.width(), area.height(), 12);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class BranchesModeWidgets
    extends ModeWidgets {
        public BranchesModeWidgets() {
            super(Mode.BRANCHES, WindowAbstractDatabase.this);
        }

        @Override
        public void createListBox(IArea area) {
            EntityPlayer player = this.database.getPlayer();
            GameProfile playerName = player.func_146103_bH();
            List<IClassification> speciesList = this.database.isNEI ? this.database.system.getAllBranches() : this.database.system.getDiscoveredBranches(this.database.getWorld(), playerName);
            ControlBranchBox controlBranchBox = new ControlBranchBox(this.modePage, area.xPos(), area.yPos(), area.width(), area.height());
            controlBranchBox.setOptions(speciesList);
            this.listBox = controlBranchBox;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private class SpeciesModeWidgets
    extends ModeWidgets {
        public SpeciesModeWidgets() {
            super(Mode.SPECIES, WindowAbstractDatabase.this);
        }

        @Override
        public void createListBox(IArea area) {
            GameProfile playerName = WindowAbstractDatabase.this.getUsername();
            Collection<IAlleleSpecies> speciesList = this.database.isNEI ? this.database.system.getAllSpecies() : this.database.system.getDiscoveredSpecies(this.database.getWorld(), playerName);
            ControlSpeciesBox controlSpeciesBox = new ControlSpeciesBox(this.modePage, area.xPos(), area.yPos(), area.width(), area.height());
            controlSpeciesBox.setOptions(speciesList);
            this.listBox = controlSpeciesBox;
        }
    }

    public static abstract class ModeWidgets {
        public WindowAbstractDatabase database;
        public ControlPage<IDatabaseMode> modePage;
        public ControlListBox listBox;
        private ControlPages<DatabaseTab> infoPages;
        private ControlTabBar<DatabaseTab> infoTabs;

        public ModeWidgets(IDatabaseMode mode, WindowAbstractDatabase database) {
            this.database = database;
            this.modePage = new ControlPage<IDatabaseMode>(database.modePages, 0, 0, database.getSize().xPos(), database.getSize().yPos(), mode);
            IArea listBoxArea = database.panelSearch.getArea().inset(2);
            this.createListBox(listBoxArea);
            CraftGUIUtil.alignToWidget(this.listBox, database.panelSearch);
            CraftGUIUtil.moveWidget(this.listBox, new Point(2, 2));
            this.infoPages = new ControlPages(this.modePage, 0, 0, 144, 176);
            CraftGUIUtil.alignToWidget(this.infoPages, database.panelInformation);
        }

        public abstract void createListBox(IArea var1);
    }

    public static enum Mode implements IDatabaseMode
    {
        SPECIES,
        BRANCHES,
        BREEDER;


        @Override
        public String getName() {
            return I18N.localise("binniecore.gui.database.mode." + this.name().toLowerCase());
        }
    }
}

