package binnie.core.network.packet;

import java.io.IOException;

import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

import io.netty.buffer.ByteBuf;

public final class MessageBinnie implements IMessage {
	public int id;
	ByteBuf data;
	private MessageBase message;

	public MessageBinnie() {
	}

	public MessageBinnie(final int id, final MessageBase base) {
		this.id = id;
		this.message = base;
	}

	@Override
	public void toBytes(final ByteBuf buf) {
		buf.writeByte(this.id);
		try {
			this.message.writeData(buf);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	@Override
	public void fromBytes(final ByteBuf buf) {
		this.id = buf.readByte();
		this.data = buf;
	}
}
