/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.incubator;

import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.machines.MachineUtil;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.incubator.IIncubatorRecipe;
import binnie.genetics.machine.incubator.IncubatorRecipe;
import binnie.genetics.machine.incubator.IncubatorRecipeLarvae;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class Incubator {
    public static final int[] SLOT_QUEUE = new int[]{0, 1, 2};
    public static final int SLOT_INCUBATOR = 3;
    public static final int[] SLOT_OUTPUT = new int[]{4, 5, 6};
    public static final int TANK_INPUT = 0;
    public static final int TANK_OUTPUT = 1;
    private static List<IIncubatorRecipe> RECIPES = new ArrayList<IIncubatorRecipe>();
    @Nullable
    private static IncubatorRecipeLarvae LARVAE_RECIPE;

    public static void addRecipes() {
        RECIPES.add(new IncubatorRecipe(GeneticsItems.GrowthMedium.get(1), new FluidStack(FluidRegistry.WATER, 25), GeneticLiquid.GrowthMedium.get(25), 0.2f));
        RECIPES.add(new IncubatorRecipe(new ItemStack(Items.field_151015_O), GeneticLiquid.GrowthMedium.get(25), GeneticLiquid.Bacteria.get(5), 0.2f));
        RECIPES.add(new IncubatorRecipe(GeneticsItems.GrowthMedium.get(1), GeneticLiquid.Bacteria.get(0), GeneticLiquid.Bacteria.get(5), 0.05f));
        RECIPES.add(new IncubatorRecipe(new ItemStack(Items.field_151102_aT), GeneticLiquid.Bacteria.get(2), null, 0.5f, 0.2f).setOutputStack(GeneticsItems.Enzyme.get(1)));
        RECIPES.add(new IncubatorRecipe(GeneticsItems.GrowthMedium.get(1), GeneticLiquid.BacteriaPoly.get(0), GeneticLiquid.BacteriaPoly.get(5), 0.05f));
        RECIPES.add(new IncubatorRecipe(GeneticsItems.GrowthMedium.get(1), GeneticLiquid.BacteriaVector.get(0), GeneticLiquid.BacteriaVector.get(5), 0.05f));
        RECIPES.add(new IncubatorRecipe(new ItemStack(Items.field_151100_aR, 1, 15), GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaPoly.get(10), 0.1f));
        RECIPES.add(new IncubatorRecipe(new ItemStack(Items.field_151065_br), GeneticLiquid.Bacteria.get(10), GeneticLiquid.BacteriaVector.get(10), 0.05f));
        if (BinnieCore.isApicultureActive()) {
            ItemStack beeLarvaeWildcard = Mods.Forestry.stack("bee_larvae_ge", 1, Short.MAX_VALUE);
            LARVAE_RECIPE = new IncubatorRecipeLarvae(beeLarvaeWildcard, GeneticLiquid.GrowthMedium.get(50), null, 1.0f, 0.05f){

                @Override
                public ItemStack getOutputStack(MachineUtil machine) {
                    ItemStack larvae = machine.getStack(3);
                    IBee bee = BeeManager.beeRoot.getMember(larvae);
                    if (bee == null) {
                        return ItemStack.field_190927_a;
                    }
                    return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)EnumBeeType.DRONE);
                }

                @Override
                public ItemStack getExpectedOutput() {
                    return Mods.Forestry.stack("bee_drone_ge", 1, Short.MAX_VALUE);
                }
            };
            RECIPES.add(LARVAE_RECIPE);
        }
    }

    public static List<IIncubatorRecipe> getRecipes() {
        return Collections.unmodifiableList(RECIPES);
    }

    @Nullable
    public static IncubatorRecipeLarvae getLarvaeRecipe() {
        return LARVAE_RECIPE;
    }
}

