/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.integration.crafttweaker.handlers;

import binnie.core.api.IBinnieRecipe;
import binnie.core.api.ICraftingManager;
import binnie.core.util.ItemStackUtil;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GenericRecipeHandler {
    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipe(ItemStack output, M manager) {
        Collection recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getOutputs()) {
                ItemStack itemStack;
                if (!(o instanceof ItemStack) || !ItemStackUtil.isItemEqual(itemStack = (ItemStack)o, output, true, false)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        CraftTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipeInput(ItemStack input, M manager) {
        Collection recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getInputs()) {
                ItemStack itemStack;
                if (!(o instanceof ItemStack) || !ItemStackUtil.isItemEqual(itemStack = (ItemStack)o, input, true, false)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        CraftTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipe(FluidStack output, M manager) {
        Collection recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getOutputs()) {
                FluidStack fluidStack;
                if (!(o instanceof FluidStack) || !(fluidStack = (FluidStack)o).isFluidEqual(output)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        CraftTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void removeRecipeInput(FluidStack input, M manager) {
        Collection recipes = manager.recipes();
        LinkedList<IBinnieRecipe> recipeToRemove = new LinkedList<IBinnieRecipe>();
        block0: for (IBinnieRecipe recipe : recipes) {
            for (Object o : recipe.getInputs()) {
                FluidStack fluidStack;
                if (!(o instanceof FluidStack) || !(fluidStack = (FluidStack)o).isFluidEqual(input)) continue;
                recipeToRemove.add(recipe);
                continue block0;
            }
        }
        CraftTweakerAPI.apply(new Remove(recipeToRemove, manager));
    }

    public static <R extends IBinnieRecipe, M extends ICraftingManager<R>> void addRecipe(R recipe, M manager) {
        CraftTweakerAPI.apply(new Add<R, M>(recipe, manager));
    }

    private static class Remove<R extends IBinnieRecipe, M extends ICraftingManager<R>>
    implements IAction {
        private final List<R> recipes;
        private final M manager;

        public Remove(List<R> recipes, M manager) {
            this.recipes = recipes;
            this.manager = manager;
        }

        public void apply() {
            this.recipes.removeIf(recipe -> !this.manager.removeRecipe(recipe));
        }

        public String describe() {
            return "Removing " + this.manager.toString() + " recipe for " + this.recipes.toString();
        }
    }

    private static class Add<R extends IBinnieRecipe, M extends ICraftingManager<R>>
    implements IAction {
        private final R recipe;
        private final M manager;

        public Add(R recipe, M manager) {
            this.recipe = recipe;
            this.manager = manager;
        }

        public void apply() {
            this.manager.addRecipe(this.recipe);
        }

        public String describe() {
            return "Adding " + this.manager.toString() + " recipe for " + this.recipe.toString();
        }
    }
}

