/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft.control;

import binnie.core.api.gui.IPoint;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.ITooltip;
import binnie.core.gui.IWidget;
import binnie.core.gui.Tooltip;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.geometry.Point;
import binnie.core.gui.minecraft.CustomSlot;
import binnie.core.gui.minecraft.MinecraftTooltip;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.control.ControlEnergyBar;
import binnie.core.gui.minecraft.control.ControlLiquidTank;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.minecraft.control.EnumHighlighting;
import binnie.core.gui.resource.minecraft.CraftGUITexture;
import binnie.core.machines.errors.ErrorState;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlErrorState
extends Control
implements ITooltip {
    @Nullable
    private ErrorState errorState;
    private int type = 0;

    public ControlErrorState(IWidget parent, int x, int y) {
        super(parent, x, y, 16, 16);
        this.addAttribute(Attribute.MOUSE_OVER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUITexture texture = CraftGUITexture.STATE_WARNING;
        if (this.errorState == null) {
            texture = CraftGUITexture.STATE_NONE;
        } else if (this.type == 0) {
            texture = CraftGUITexture.STATE_ERROR;
        }
        CraftGUI.RENDER.texture((Object)texture, (IPoint)Point.ZERO);
        super.onRenderBackground(guiWidth, guiHeight);
    }

    @Nullable
    public ErrorState getError() {
        return ((Window)Window.get(this)).getContainer().getErrorState();
    }

    @Override
    public final void onUpdateClient() {
        this.errorState = this.getError();
        this.type = ((Window)Window.get(this)).getContainer().getErrorType();
        ControlSlot.highlighting.get((Object)EnumHighlighting.ERROR).clear();
        ControlSlot.highlighting.get((Object)EnumHighlighting.WARNING).clear();
        ControlLiquidTank.tankError.clear();
        ControlEnergyBar.isError = false;
        if (!this.isMouseOver() || this.errorState == null) {
            return;
        }
        ControlEnergyBar.isError = this.errorState.isPowerError();
        if (this.errorState.isItemError()) {
            for (int slot : this.errorState.getData()) {
                int id = -1;
                for (CustomSlot cslot : ((Window)Window.get(this)).getContainer().getCustomSlots()) {
                    if (cslot.field_75224_c instanceof InventoryPlayer || cslot.getSlotIndex() != slot) continue;
                    id = cslot.field_75222_d;
                }
                if (id < 0) continue;
                if (this.type == 0) {
                    ControlSlot.highlighting.get((Object)EnumHighlighting.ERROR).add(id);
                    continue;
                }
                ControlSlot.highlighting.get((Object)EnumHighlighting.WARNING).add(id);
            }
        }
        if (this.errorState.isTankError()) {
            for (int slot : this.errorState.getData()) {
                ControlLiquidTank.tankError.add(slot);
            }
        }
    }

    @Override
    public void getTooltip(Tooltip tooltipOrig, ITooltipFlag tooltipFlag) {
        MinecraftTooltip tooltip = (MinecraftTooltip)tooltipOrig;
        if (this.errorState != null) {
            if (this.type == 0) {
                tooltip.setType(MinecraftTooltip.Type.ERROR);
            } else {
                tooltip.setType(MinecraftTooltip.Type.WARNING);
            }
            tooltip.add(this.errorState.toString());
            if (this.errorState.getTooltip().length() > 0) {
                tooltip.add(this.errorState.getTooltip());
            }
        }
    }
}

