/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.fieldkit;

import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.genetics.IFieldKitPlugin;
import binnie.core.api.gui.IPoint;
import binnie.core.api.gui.ITexture;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.IWidget;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.fieldkit.ControlChromoPicker;
import binnie.core.gui.geometry.Point;
import com.google.common.base.Preconditions;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ControlChromosome
extends Control
implements IControlValue<IChromosomeType> {
    @Nullable
    private IChromosomeType chromo;
    @Nullable
    private IBreedingSystem breedingSystem;

    public ControlChromosome(IWidget parent, int x, int y) {
        super(parent, x, y, 96, 96);
    }

    public ISpeciesRoot getRoot() {
        Preconditions.checkState((this.breedingSystem != null ? 1 : 0) != 0, (Object)"root has not been set");
        return this.breedingSystem.getSpeciesRoot();
    }

    public void setSystem(@Nullable IBreedingSystem breedingSystem) {
        if (this.breedingSystem != breedingSystem) {
            this.breedingSystem = breedingSystem;
            this.deleteAllChildren();
            if (breedingSystem != null) {
                IFieldKitPlugin fieldKitPlugin = breedingSystem.getFieldKitPlugin();
                fieldKitPlugin.getChromosomePickerPositions();
                for (Map.Entry entry : fieldKitPlugin.getChromosomePickerPositions().entrySet()) {
                    IChromosomeType chromosomeType = (IChromosomeType)entry.getKey();
                    IPoint position = (IPoint)entry.getValue();
                    new ControlChromoPicker(this, position.xPos(), position.yPos(), chromosomeType);
                }
            }
        }
    }

    @Override
    public IChromosomeType getValue() {
        return this.chromo;
    }

    @Override
    public void setValue(IChromosomeType value) {
        this.chromo = value;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderBackground(int guiWidth, int guiHeight) {
        if (this.breedingSystem == null) {
            return;
        }
        super.onRenderBackground(guiWidth, guiHeight);
        ITexture texture = this.getTypeTexture();
        CraftGUI.RENDER.texture(texture, (IPoint)Point.ZERO);
    }

    @Nullable
    private ITexture getTypeTexture() {
        if (this.breedingSystem == null) {
            return null;
        }
        IFieldKitPlugin fieldKitPlugin = this.breedingSystem.getFieldKitPlugin();
        return fieldKitPlugin.getTypeTexture();
    }
}

