/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.Binnie;
import binnie.core.api.genetics.IBreedingSystem;
import binnie.core.api.genetics.IGene;
import com.google.common.base.Preconditions;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.nbt.NBTTagCompound;

public class Gene
implements IGene {
    private IAllele allele;
    private IChromosomeType chromosome;
    private ISpeciesRoot root;

    public Gene(IAllele allele, IChromosomeType chromosome, ISpeciesRoot root) {
        this.allele = allele;
        this.chromosome = chromosome;
        this.root = root;
    }

    public Gene(NBTTagCompound nbt) {
        this.allele = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i("allele"));
        String rootKey = nbt.func_74779_i("root");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(rootKey);
        Preconditions.checkArgument((root != null ? 1 : 0) != 0, (String)"Could not find root: %s", (Object)rootKey);
        this.root = root;
        byte chromoID = nbt.func_74771_c("chromo");
        Preconditions.checkArgument((chromoID >= 0 && chromoID < this.root.getKaryotype().length ? 1 : 0) != 0, (String)"Invalid chromosomeId: %s", (int)chromoID);
        this.chromosome = this.root.getKaryotype()[chromoID];
    }

    public static Gene create(NBTTagCompound nbt) {
        return new Gene(nbt);
    }

    public static Gene create(IAllele allele, IChromosomeType chromosome, ISpeciesRoot root) {
        return new Gene(allele, chromosome, root);
    }

    public ISpeciesRoot getSpeciesRoot() {
        return this.root;
    }

    public String toString() {
        return this.getAlleleName();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.allele = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i("allele"));
        String rootKey = nbt.func_74779_i("root");
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(rootKey);
        Preconditions.checkArgument((root != null ? 1 : 0) != 0, (String)"Could not find root: %s", (Object)rootKey);
        this.root = root;
        byte chromoID = nbt.func_74771_c("chromo");
        Preconditions.checkArgument((chromoID >= 0 && chromoID < this.root.getKaryotype().length ? 1 : 0) != 0, (String)"Invalid chromosomeId: %s", (int)chromoID);
        this.chromosome = this.root.getKaryotype()[chromoID];
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("allele", this.allele.getUID());
        nbt.func_74778_a("root", this.root.getUID());
        nbt.func_74774_a("chromo", (byte)this.chromosome.ordinal());
        return nbt;
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public String getName() {
        return Binnie.GENETICS.getSystem(this.root).getAlleleName(this.chromosome, this.allele);
    }

    public IBreedingSystem getSystem() {
        return Binnie.GENETICS.getSystem(this.root);
    }

    public IChromosomeType getChromosome() {
        return this.chromosome;
    }

    public IAllele getAllele() {
        return this.allele;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Gene)) {
            return false;
        }
        Gene g = (Gene)obj;
        return this.allele == g.allele && this.chromosome.ordinal() == g.chromosome.ordinal() && this.root == g.root;
    }

    public String getAlleleName() {
        return this.getSystem().getAlleleName(this.chromosome, this.allele);
    }

    public String getShortChromosomeName() {
        return this.getSystem().getChromosomeShortName(this.chromosome);
    }
}

